/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLObject;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class RegionFunction
extends GeometryFunction {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "REGION", true, "Express a region on the sky in a generic way (e.g. STC-S).");
    public static final LanguageFeature FEATURE_UNION = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "UNION", true, "Express a region being the union of two (or more) other regions. This is only supported in STC-s expressions of the REGION(...) function.");
    public static final LanguageFeature FEATURE_INTERSECT = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo", "INTERSECT", true, "Express a region being the intersection of two (or more) other regions. This is only supported in STC-s expressions of the REGION(...) function.");
    protected ADQLOperand parameter;
    protected boolean extendedRegionExpression = false;

    public RegionFunction(ADQLOperand param) throws Exception {
        if (param == null) {
            throw new NullPointerException("The ADQL function REGION must have exactly one parameter!");
        }
        if (!param.isString()) {
            throw new Exception("The only required parameter of a REGION function must be a string literal!");
        }
        this.parameter = param;
    }

    public RegionFunction(RegionFunction toCopy) throws Exception {
        this.parameter = (ADQLOperand)toCopy.parameter.getCopy();
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new RegionFunction(this);
    }

    @Override
    public String getName() {
        return "REGION";
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    public boolean isExtendedRegionExpression() {
        return this.extendedRegionExpression;
    }

    public void setExtendedRegionExpression(boolean extendedExpression) {
        this.extendedRegionExpression = extendedExpression;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int index) throws ArrayIndexOutOfBoundsException {
        if (index == 0) {
            return this.parameter;
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }

    @Override
    public ADQLOperand setParameter(int index, ADQLOperand replacer) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (index == 0) {
            if (replacer == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of a " + this.getName() + " function!");
            }
            if (replacer instanceof ADQLOperand) {
                ADQLOperand replaced = this.parameter;
                this.parameter = replacer;
                this.setPosition(null);
                return replaced;
            }
            throw new Exception("Impossible to replace an ADQLOperand by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
        }
        throw new ArrayIndexOutOfBoundsException("No " + index + "-th parameter for the function \"" + this.getName() + "\"!");
    }
}

