#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 1; apic id = 01
# fault virtual address   = 0x18
# fault code              = supervisor read data, page not present
# instruction pointer     = 0x20:0xffffffff80b69835
# stack pointer           = 0x28:0xfffffe00ff8e7d90
# frame pointer           = 0x28:0xfffffe00ff8e7d90
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, long 1, def32 0, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 0 (thread taskq)
# rdi: 0000000000000018 rsi: 0000000000000004 rdx: ffffffff812b3f65
# rcx: 00000000000008ba  r8: fffff800044b8780  r9: fffff80003397000
# rax: 0000000000000001 rbx: fffff8004221fa00 rbp: fffffe00ff8e7d90
# r10: 0000000000000001 r11: fffffe00dc47b000 r12: fffffe0177ed0000
# r13: fffff800044b8780 r14: fffff8004221f800 r15: fffff8004221f800
# trap number             = 12
# panic: page fault
# cpuid = 1
# time = 1759322830
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00ff8e7ac0
# vpanic() at vpanic+0x136/frame 0xfffffe00ff8e7bf0
# panic() at panic+0x43/frame 0xfffffe00ff8e7c50
# trap_pfault() at trap_pfault+0x47c/frame 0xfffffe00ff8e7cc0
# calltrap() at calltrap+0x8/frame 0xfffffe00ff8e7cc0
# --- trap 0xc, rip = 0xffffffff80b69835, rsp = 0xfffffe00ff8e7d90, rbp = 0xfffffe00ff8e7d90 ---
# __mtx_assert() at __mtx_assert+0x35/frame 0xfffffe00ff8e7d90
# ktls_check_rx() at ktls_check_rx+0x2f/frame 0xfffffe00ff8e7dd0
# socantrcvmore() at socantrcvmore+0x5e/frame 0xfffffe00ff8e7df0
# unp_gc() at unp_gc+0x5df/frame 0xfffffe00ff8e7e40
# taskqueue_run_locked() at taskqueue_run_locked+0x1c2/frame 0xfffffe00ff8e7ec0
# taskqueue_thread_loop() at taskqueue_thread_loop+0xd3/frame 0xfffffe00ff8e7ef0
# fork_exit() at fork_exit+0x82/frame 0xfffffe00ff8e7f30
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe00ff8e7f30
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 0 tid 100045 ]
# Stopped at      kdb_enter+0x33: movq    $0,0x121a9e2(%rip)
# db> x/s version
# version: FreeBSD 16.0-CURRENT #0 vmfqe-n280784-b7f165e45d6d: Wed Oct  1 13:48:43 CEST 2025
# pho@mercat1.netperf.freebsd.org:/var/tmp/deviant3/sys/amd64/compile/PHO
# db> 

[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
set -u
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=ec40fe3e3e2b41218d1d417bc10d0be2517bf751
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// syzbot+a62883292a5c257703be@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <dirent.h>
#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void use_temporary_dir(void)
{
  char tmpdir_template[] = "./syzkaller.XXXXXX";
  char* tmpdir = mkdtemp(tmpdir_template);
  if (!tmpdir)
    exit(1);
  if (chmod(tmpdir, 0777))
    exit(1);
  if (chdir(tmpdir))
    exit(1);
}

static void reset_flags(const char* filename)
{
  struct stat st;
  if (lstat(filename, &st))
    exit(1);
  st.st_flags &= ~(SF_NOUNLINK | UF_NOUNLINK | SF_IMMUTABLE | UF_IMMUTABLE |
                   SF_APPEND | UF_APPEND);
  if (lchflags(filename, st.st_flags))
    exit(1);
}
static void __attribute__((noinline)) remove_dir(const char* dir)
{
  DIR* dp = opendir(dir);
  if (dp == NULL) {
    if (errno == EACCES) {
      if (rmdir(dir))
        exit(1);
      return;
    }
    exit(1);
  }
  struct dirent* ep = 0;
  while ((ep = readdir(dp))) {
    if (strcmp(ep->d_name, ".") == 0 || strcmp(ep->d_name, "..") == 0)
      continue;
    char filename[FILENAME_MAX];
    snprintf(filename, sizeof(filename), "%s/%s", dir, ep->d_name);
    struct stat st;
    if (lstat(filename, &st))
      exit(1);
    if (S_ISDIR(st.st_mode)) {
      remove_dir(filename);
      continue;
    }
    if (unlink(filename)) {
      if (errno == EPERM) {
        reset_flags(filename);
        reset_flags(dir);
        if (unlink(filename) == 0)
          continue;
      }
      exit(1);
    }
  }
  closedir(dp);
  while (rmdir(dir)) {
    if (errno == EPERM) {
      reset_flags(dir);
      if (rmdir(dir) == 0)
        break;
    }
    exit(1);
  }
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static void sandbox_common()
{
  struct rlimit rlim;
  rlim.rlim_cur = rlim.rlim_max = 128 << 20;
  setrlimit(RLIMIT_AS, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 8 << 20;
  setrlimit(RLIMIT_MEMLOCK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_FSIZE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 1 << 20;
  setrlimit(RLIMIT_STACK, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 0;
  setrlimit(RLIMIT_CORE, &rlim);
  rlim.rlim_cur = rlim.rlim_max = 256;
  setrlimit(RLIMIT_NOFILE, &rlim);
}

static void loop();

static int do_sandbox_none(void)
{
  sandbox_common();
  loop();
  return 0;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  if (write(1, "executing program\n", sizeof("executing program\n") - 1)) {
  }
  int i, call, thread;
  for (call = 0; call < 8; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter = 0;
  for (;; iter++) {
    char cwdbuf[32];
    sprintf(cwdbuf, "./%d", iter);
    if (mkdir(cwdbuf, 0777))
      exit(1);
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      if (chdir(cwdbuf))
        exit(1);
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      sleep_ms(10);
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
    remove_dir(cwdbuf);
  }
}

uint64_t r[3] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    //  freebsd10_pipe arguments: [
    //    pipefd: ptr[out, pipefd] {
    //      pipefd {
    //        rfd: fd (resource)
    //        wfd: fd (resource)
    //      }
    //    }
    //  ]
    res = syscall(SYS_freebsd10_pipe, /*pipefd=*/0x2000000001c0ul);
    if (res != -1)
      r[0] = *(uint32_t*)0x2000000001c4;
    break;
  case 1:
    //  close arguments: [
    //    fd: fd (resource)
    //  ]
    syscall(SYS_close, /*fd=*/r[0]);
    break;
  case 2:
    //  socket\$unix arguments: [
    //    domain: const = 0x1 (8 bytes)
    //    type: unix_socket_type = 0x5 (8 bytes)
    //    proto: const = 0x0 (1 bytes)
    //  ]
    //  returns sock_unix
    res = syscall(SYS_socket, /*domain=*/1ul, /*type=SOCK_SEQPACKET*/ 5ul,
                  /*proto=*/0);
    if (res != -1)
      r[1] = res;
    break;
  case 3:
    //  bind\$unix arguments: [
    //    fd: sock_unix (resource)
    //    addr: ptr[in, sockaddr_un] {
    //      union sockaddr_un {
    //        file: sockaddr_un_file {
    //          len: len = 0xa (1 bytes)
    //          family: unix_socket_family = 0x1 (1 bytes)
    //          path: buffer: {2e 2f 66 69 6c 65 31 00} (length 0x8)
    //        }
    //      }
    //    }
    //    addrlen: len = 0xa (8 bytes)
    //  ]
    *(uint8_t*)0x2000000002c0 = 0xa;
    *(uint8_t*)0x2000000002c1 = 1;
    memcpy((void*)0x2000000002c2, "./file1\000", 8);
    syscall(SYS_bind, /*fd=*/r[1], /*addr=*/0x2000000002c0ul,
            /*addrlen=*/0xaul);
    break;
  case 4:
    //  listen arguments: [
    //    fd: sock (resource)
    //    backlog: int32 = 0xfffffffe (4 bytes)
    //  ]
    syscall(SYS_listen, /*fd=*/r[1], /*backlog=*/0xfffffffe);
    break;
  case 5:
    //  sendmsg\$unix arguments: [
    //    fd: sock_unix (resource)
    //    msg: ptr[in, msghdr_un] {
    //      msghdr_un {
    //        addr: nil
    //        addrlen: len = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //        vec: nil
    //        vlen: len = 0x0 (8 bytes)
    //        ctrl: ptr[inout, array[ANYUNION]] {
    //          array[ANYUNION] {
    //            union ANYUNION {
    //              ANYBLOB: buffer: {89 00 00 00 ff ff 00 00 01} (length 0x9)
    //            }
    //          }
    //        }
    //        ctrllen: bytesize = 0x9 (8 bytes)
    //        f: send_flags = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //      }
    //    }
    //    f: send_flags = 0x0 (8 bytes)
    //  ]
    *(uint64_t*)0x200000000080 = 0;
    *(uint32_t*)0x200000000088 = 0;
    *(uint64_t*)0x200000000090 = 0;
    *(uint64_t*)0x200000000098 = 0;
    *(uint64_t*)0x2000000000a0 = 0x200000000000;
    memcpy((void*)0x200000000000, "\x89\x00\x00\x00\xff\xff\x00\x00\x01", 9);
    *(uint64_t*)0x2000000000a8 = 9;
    *(uint32_t*)0x2000000000b0 = 0;
    syscall(SYS_sendmsg, /*fd=*/(intptr_t)-1, /*msg=*/0x200000000080ul,
            /*f=*/0ul);
    break;
  case 6:
    //  socketpair\$unix arguments: [
    //    domain: const = 0x1 (8 bytes)
    //    type: unix_socket_type = 0x2 (8 bytes)
    //    proto: const = 0x0 (1 bytes)
    //    fds: ptr[out, unix_pair] {
    //      unix_pair {
    //        fd0: sock_unix (resource)
    //        fd1: sock_unix (resource)
    //      }
    //    }
    //  ]
    res = syscall(SYS_socketpair, /*domain=*/1ul, /*type=SOCK_DGRAM*/ 2ul,
                  /*proto=*/0, /*fds=*/0x200000000040ul);
    if (res != -1)
      r[2] = *(uint32_t*)0x200000000040;
    break;
  case 7:
    //  sendmsg arguments: [
    //    fd: sock (resource)
    //    msg: ptr[in, send_msghdr] {
    //      send_msghdr {
    //        msg_name: nil
    //        msg_namelen: len = 0x32c (4 bytes)
    //        pad = 0x0 (4 bytes)
    //        msg_iov: nil
    //        msg_iovlen: len = 0x0 (8 bytes)
    //        msg_control: ptr[in, array[cmsghdr]] {
    //          array[cmsghdr] {
    //          }
    //        }
    //        msg_controllen: bytesize = 0x90 (8 bytes)
    //        msg_flags: const = 0x0 (4 bytes)
    //        pad = 0x0 (4 bytes)
    //      }
    //    }
    //    f: send_flags = 0x0 (8 bytes)
    //  ]
    *(uint64_t*)0x200000000380 = 0;
    *(uint32_t*)0x200000000388 = 0x32c;
    *(uint64_t*)0x200000000390 = 0;
    *(uint64_t*)0x200000000398 = 0;
    *(uint64_t*)0x2000000003a0 = 0x200000000000;
    *(uint64_t*)0x2000000003a8 = 0x90;
    *(uint32_t*)0x2000000003b0 = 0;
    syscall(SYS_sendmsg, /*fd=*/r[2], /*msg=*/0x200000000380ul, /*f=*/0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, /*addr=*/0x200000000000ul, /*len=*/0x1000000ul,
          /*prot=PROT_WRITE|PROT_READ|PROT_EXEC*/ 7ul,
          /*flags=MAP_FIXED|MAP_ANONYMOUS|MAP_PRIVATE*/ 0x1012ul,
          /*fd=*/(intptr_t)-1, /*offset=*/0ul);
  const char* reason;
  (void)reason;
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      use_temporary_dir();
      do_sandbox_none();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -pthread || exit 1

work=/tmp/$prog.dir
rm -rf $work
mkdir $work
cd /tmp/$prog.dir
for i in `jot 30`; do
	(
		mkdir d$i
		cd d$i
		timeout 3m /tmp/$prog > /dev/null 2>&1 &
	)
done
while pgrep -q $prog; do sleep 2; done
wait

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core $work
exit 0
