import { useCallback } from 'react';
import { useAnalyticsEvents } from './useAnalyticsEvents';
import { useTrackedRef } from './useTrackedRef';
export const useCallbackWithAnalytics = (method, payload, channel) => {
  const {
    createAnalyticsEvent
  } = useAnalyticsEvents();
  const methodRef = useTrackedRef(method);
  const payloadRef = useTrackedRef(payload);
  return useCallback((...args) => {
    const pload = typeof payloadRef.current === 'function' ? payloadRef.current(...args) : payloadRef.current;
    createAnalyticsEvent(pload).fire(channel);
    methodRef.current(...args);
  }, [createAnalyticsEvent, methodRef, payloadRef, channel]);
};