import type { Direction, DroppableMode } from 'react-beautiful-dnd';
export type DroppableContextProps = {
    direction: Direction;
    droppableId: string;
    shouldRenderCloneWhileDragging: boolean;
    isDropDisabled: boolean;
    type: string;
    mode: DroppableMode;
};
export declare const DroppableContextProvider: import("react").Provider<DroppableContextProps | null>;
/**
 * Intended for use by `<Draggable>` instances.
 */
export declare function useDroppableContext(): DroppableContextProps;
/**
 * Returns the `droppableId` of the parent droppable, if there is one.
 *
 * Intended for use only by `<Droppable>` instances.
 */
export declare function useParentDroppableId(): string | null;
