/**
 * @jsxRuntime classic
 * @jsx jsx
 */
import { type ElementType, type ReactNode } from 'react';
import { type Space } from '../xcss/style-maps.partial';
import type { BasePrimitiveProps } from './types';
export type GridProps<T extends ElementType = 'div'> = {
    /**
     * The DOM element to render as the Grid. Defaults to `div`.
     */
    as?: 'div' | 'span' | 'ul' | 'ol';
    /**
     * Used to align children along the inline axis.
     */
    justifyContent?: JustifyContent;
    /**
     * Used to align the grid along the inline axis.
     */
    justifyItems?: JustifyItems;
    /**
     * Used to align children along the block axis.
     */
    alignItems?: AlignItems;
    /**
     * Used to align the grid along the block axis.
     */
    alignContent?: AlignContent;
    /**
     * Represents the space between each column.
     */
    columnGap?: Space;
    /**
     * Represents the space between each child across both axes.
     */
    gap?: Space;
    /**
     * Represents the space between each row.
     */
    rowGap?: Space;
    /**
     * Specifies how auto-placed items get flowed into the grid. CSS `grid-auto-flow`.
     */
    autoFlow?: AutoFlow;
    /**
     * CSS `grid-template-rows`.
     */
    templateRows?: string;
    /**
     * CSS `grid-template-columns`.
     */
    templateColumns?: string;
    /**
     * CSS `grid-template-areas`.
     *
     * Each item in the passed array is a grid row.
     */
    templateAreas?: string[];
    /**
     * Elements to be rendered inside the grid. Required as a grid without children should not be a grid.
     */
    children: ReactNode;
    /**
     * HTML id attrubute.
     */
    id?: string;
    /**
     * Forwarded ref element.
     */
    ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;
type JustifyContent = keyof typeof justifyContentMap;
type JustifyItems = keyof typeof justifyItemsMap;
type AlignItems = keyof typeof alignItemsMap;
type AlignContent = keyof typeof alignContentMap;
declare const justifyContentMap: {
    readonly start: import("@emotion/react").SerializedStyles;
    readonly center: import("@emotion/react").SerializedStyles;
    readonly end: import("@emotion/react").SerializedStyles;
    readonly 'space-between': import("@emotion/react").SerializedStyles;
    readonly 'space-around': import("@emotion/react").SerializedStyles;
    readonly 'space-evenly': import("@emotion/react").SerializedStyles;
    readonly stretch: import("@emotion/react").SerializedStyles;
};
declare const justifyItemsMap: {
    readonly start: import("@emotion/react").SerializedStyles;
    readonly center: import("@emotion/react").SerializedStyles;
    readonly end: import("@emotion/react").SerializedStyles;
    readonly stretch: import("@emotion/react").SerializedStyles;
};
declare const alignContentMap: {
    readonly start: import("@emotion/react").SerializedStyles;
    readonly center: import("@emotion/react").SerializedStyles;
    readonly end: import("@emotion/react").SerializedStyles;
    readonly 'space-between': import("@emotion/react").SerializedStyles;
    readonly 'space-around': import("@emotion/react").SerializedStyles;
    readonly 'space-evenly': import("@emotion/react").SerializedStyles;
    readonly stretch: import("@emotion/react").SerializedStyles;
};
declare const alignItemsMap: {
    readonly start: import("@emotion/react").SerializedStyles;
    readonly center: import("@emotion/react").SerializedStyles;
    readonly baseline: import("@emotion/react").SerializedStyles;
    readonly end: import("@emotion/react").SerializedStyles;
};
type AutoFlow = keyof typeof gridAutoFlowMap;
declare const gridAutoFlowMap: {
    readonly row: import("@emotion/react").SerializedStyles;
    readonly column: import("@emotion/react").SerializedStyles;
    readonly dense: import("@emotion/react").SerializedStyles;
    readonly 'row dense': import("@emotion/react").SerializedStyles;
    readonly 'column dense': import("@emotion/react").SerializedStyles;
};
/**
 * __Grid__
 *
 * `Grid` is a primitive component that implements the CSS Grid API.
 *
 * - [Examples](https://atlassian.design/components/primitives/grid/examples)
 * - [Code](https://atlassian.design/components/primitives/grid/code)
 *
 * @example
 * ```tsx
 * import { Grid, Box } from '@atlaskit/primitives'
 *
 * const Component = () => (
 *   <Grid gap="space.100" gridColumns="1fr 1fr">
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *     <Box padding="space.100" backgroundColor="neutral"></Box>
 *   </Grid>
 * )
 * ```
 */
declare const Grid: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Omit<GridProps<ElementType>, "ref"> & import("react").RefAttributes<any>>>;
export default Grid;
