<!-- API Report Version: 2.3 -->

## API Report File for "@atlaskit/primitives"

> Do not edit this file. This report is auto-generated using
> [API Extractor](https://api-extractor.com/).
> [Learn more about API reports](https://hello.atlassian.net/wiki/spaces/UR/pages/1825484529/Package+API+Reports)

### Table of contents

- [Main Entry Types](#main-entry-types)
- [Peer Dependencies](#peer-dependencies)

### Main Entry Types

<!--SECTION START: Main Entry Types-->

```ts
import { ComponentPropsWithoutRef } from 'react';
import { ComponentPropsWithRef } from 'react';
import type * as CSS_2 from 'csstype';
import type { CSSProperties } from 'react';
import type { CSSPropertiesWithMultiValues } from '@emotion/serialize';
import { ElementType } from 'react';
import { FC } from 'react';
import { ForwardRefExoticComponent } from 'react';
import { jsx } from '@emotion/react';
import { MemoExoticComponent } from 'react';
import { ReactElement } from 'react';
import { ReactNode } from 'react';
import { RefAttributes } from 'react';
import type { SerializedStyles } from '@emotion/serialize';
import { SerializedStyles as SerializedStyles_2 } from '@emotion/react';

// @public (undocumented)
type AlignBlock = 'baseline' | 'center' | 'end' | 'start' | 'stretch';

// @public (undocumented)
type AlignContent = keyof typeof alignContentMap;

// @public (undocumented)
const alignContentMap: {
	readonly start: SerializedStyles_2;
	readonly center: SerializedStyles_2;
	readonly end: SerializedStyles_2;
	readonly 'space-between': SerializedStyles_2;
	readonly 'space-around': SerializedStyles_2;
	readonly 'space-evenly': SerializedStyles_2;
	readonly stretch: SerializedStyles_2;
};

// @public (undocumented)
type AlignInline = 'center' | 'end' | 'start' | 'stretch';

// @public (undocumented)
type AlignItems = keyof typeof alignItemsMap;

// @public (undocumented)
type AlignItems_2 = keyof typeof alignItemsMap_2;

// @public (undocumented)
const alignItemsMap: {
	readonly start: SerializedStyles_2;
	readonly center: SerializedStyles_2;
	readonly baseline: SerializedStyles_2;
	readonly end: SerializedStyles_2;
	readonly stretch: SerializedStyles_2;
};

// @public (undocumented)
const alignItemsMap_2: {
	readonly start: SerializedStyles_2;
	readonly center: SerializedStyles_2;
	readonly baseline: SerializedStyles_2;
	readonly end: SerializedStyles_2;
};

// @public (undocumented)
type AllMedia =
	| '@media (prefers-color-scheme: dark)'
	| '@media (prefers-color-scheme: light)'
	| '@media (prefers-reduced-motion: reduce)'
	| '@media screen and (forced-colors: active), screen and (-ms-high-contrast: active)'
	| MediaQuery;

// @public (undocumented)
type AllowedElements = Exclude<keyof JSX.IntrinsicElements, SVGElements>;

// @public (undocumented)
const asAllowlist: readonly ['span', 'p', 'strong', 'em'];

// @public (undocumented)
type AsElement = (typeof asAllowlist)[number];

// @public (undocumented)
type AtRulesWithoutMedia = Exclude<CSS_2.AtRules, '@media'>;

// @public (undocumented)
type AutoComplete<T extends string> = Omit<string, T> | T;

// @public (undocumented)
type AutoFlow = keyof typeof gridAutoFlowMap;

// @public (undocumented)
export type BackgroundColor = keyof typeof backgroundColorMap;

// @public (undocumented)
const backgroundColorMap: {
	readonly 'color.background.accent.lime.subtlest': 'var(--ds-background-accent-lime-subtlest)';
	readonly 'color.background.accent.lime.subtlest.hovered': 'var(--ds-background-accent-lime-subtlest-hovered)';
	readonly 'color.background.accent.lime.subtlest.pressed': 'var(--ds-background-accent-lime-subtlest-pressed)';
	readonly 'color.background.accent.lime.subtler': 'var(--ds-background-accent-lime-subtler)';
	readonly 'color.background.accent.lime.subtler.hovered': 'var(--ds-background-accent-lime-subtler-hovered)';
	readonly 'color.background.accent.lime.subtler.pressed': 'var(--ds-background-accent-lime-subtler-pressed)';
	readonly 'color.background.accent.lime.subtle': 'var(--ds-background-accent-lime-subtle)';
	readonly 'color.background.accent.lime.subtle.hovered': 'var(--ds-background-accent-lime-subtle-hovered)';
	readonly 'color.background.accent.lime.subtle.pressed': 'var(--ds-background-accent-lime-subtle-pressed)';
	readonly 'color.background.accent.lime.bolder': 'var(--ds-background-accent-lime-bolder)';
	readonly 'color.background.accent.lime.bolder.hovered': 'var(--ds-background-accent-lime-bolder-hovered)';
	readonly 'color.background.accent.lime.bolder.pressed': 'var(--ds-background-accent-lime-bolder-pressed)';
	readonly 'color.background.accent.red.subtlest': 'var(--ds-background-accent-red-subtlest)';
	readonly 'color.background.accent.red.subtlest.hovered': 'var(--ds-background-accent-red-subtlest-hovered)';
	readonly 'color.background.accent.red.subtlest.pressed': 'var(--ds-background-accent-red-subtlest-pressed)';
	readonly 'color.background.accent.red.subtler': 'var(--ds-background-accent-red-subtler)';
	readonly 'color.background.accent.red.subtler.hovered': 'var(--ds-background-accent-red-subtler-hovered)';
	readonly 'color.background.accent.red.subtler.pressed': 'var(--ds-background-accent-red-subtler-pressed)';
	readonly 'color.background.accent.red.subtle': 'var(--ds-background-accent-red-subtle)';
	readonly 'color.background.accent.red.subtle.hovered': 'var(--ds-background-accent-red-subtle-hovered)';
	readonly 'color.background.accent.red.subtle.pressed': 'var(--ds-background-accent-red-subtle-pressed)';
	readonly 'color.background.accent.red.bolder': 'var(--ds-background-accent-red-bolder)';
	readonly 'color.background.accent.red.bolder.hovered': 'var(--ds-background-accent-red-bolder-hovered)';
	readonly 'color.background.accent.red.bolder.pressed': 'var(--ds-background-accent-red-bolder-pressed)';
	readonly 'color.background.accent.orange.subtlest': 'var(--ds-background-accent-orange-subtlest)';
	readonly 'color.background.accent.orange.subtlest.hovered': 'var(--ds-background-accent-orange-subtlest-hovered)';
	readonly 'color.background.accent.orange.subtlest.pressed': 'var(--ds-background-accent-orange-subtlest-pressed)';
	readonly 'color.background.accent.orange.subtler': 'var(--ds-background-accent-orange-subtler)';
	readonly 'color.background.accent.orange.subtler.hovered': 'var(--ds-background-accent-orange-subtler-hovered)';
	readonly 'color.background.accent.orange.subtler.pressed': 'var(--ds-background-accent-orange-subtler-pressed)';
	readonly 'color.background.accent.orange.subtle': 'var(--ds-background-accent-orange-subtle)';
	readonly 'color.background.accent.orange.subtle.hovered': 'var(--ds-background-accent-orange-subtle-hovered)';
	readonly 'color.background.accent.orange.subtle.pressed': 'var(--ds-background-accent-orange-subtle-pressed)';
	readonly 'color.background.accent.orange.bolder': 'var(--ds-background-accent-orange-bolder)';
	readonly 'color.background.accent.orange.bolder.hovered': 'var(--ds-background-accent-orange-bolder-hovered)';
	readonly 'color.background.accent.orange.bolder.pressed': 'var(--ds-background-accent-orange-bolder-pressed)';
	readonly 'color.background.accent.yellow.subtlest': 'var(--ds-background-accent-yellow-subtlest)';
	readonly 'color.background.accent.yellow.subtlest.hovered': 'var(--ds-background-accent-yellow-subtlest-hovered)';
	readonly 'color.background.accent.yellow.subtlest.pressed': 'var(--ds-background-accent-yellow-subtlest-pressed)';
	readonly 'color.background.accent.yellow.subtler': 'var(--ds-background-accent-yellow-subtler)';
	readonly 'color.background.accent.yellow.subtler.hovered': 'var(--ds-background-accent-yellow-subtler-hovered)';
	readonly 'color.background.accent.yellow.subtler.pressed': 'var(--ds-background-accent-yellow-subtler-pressed)';
	readonly 'color.background.accent.yellow.subtle': 'var(--ds-background-accent-yellow-subtle)';
	readonly 'color.background.accent.yellow.subtle.hovered': 'var(--ds-background-accent-yellow-subtle-hovered)';
	readonly 'color.background.accent.yellow.subtle.pressed': 'var(--ds-background-accent-yellow-subtle-pressed)';
	readonly 'color.background.accent.yellow.bolder': 'var(--ds-background-accent-yellow-bolder)';
	readonly 'color.background.accent.yellow.bolder.hovered': 'var(--ds-background-accent-yellow-bolder-hovered)';
	readonly 'color.background.accent.yellow.bolder.pressed': 'var(--ds-background-accent-yellow-bolder-pressed)';
	readonly 'color.background.accent.green.subtlest': 'var(--ds-background-accent-green-subtlest)';
	readonly 'color.background.accent.green.subtlest.hovered': 'var(--ds-background-accent-green-subtlest-hovered)';
	readonly 'color.background.accent.green.subtlest.pressed': 'var(--ds-background-accent-green-subtlest-pressed)';
	readonly 'color.background.accent.green.subtler': 'var(--ds-background-accent-green-subtler)';
	readonly 'color.background.accent.green.subtler.hovered': 'var(--ds-background-accent-green-subtler-hovered)';
	readonly 'color.background.accent.green.subtler.pressed': 'var(--ds-background-accent-green-subtler-pressed)';
	readonly 'color.background.accent.green.subtle': 'var(--ds-background-accent-green-subtle)';
	readonly 'color.background.accent.green.subtle.hovered': 'var(--ds-background-accent-green-subtle-hovered)';
	readonly 'color.background.accent.green.subtle.pressed': 'var(--ds-background-accent-green-subtle-pressed)';
	readonly 'color.background.accent.green.bolder': 'var(--ds-background-accent-green-bolder)';
	readonly 'color.background.accent.green.bolder.hovered': 'var(--ds-background-accent-green-bolder-hovered)';
	readonly 'color.background.accent.green.bolder.pressed': 'var(--ds-background-accent-green-bolder-pressed)';
	readonly 'color.background.accent.teal.subtlest': 'var(--ds-background-accent-teal-subtlest)';
	readonly 'color.background.accent.teal.subtlest.hovered': 'var(--ds-background-accent-teal-subtlest-hovered)';
	readonly 'color.background.accent.teal.subtlest.pressed': 'var(--ds-background-accent-teal-subtlest-pressed)';
	readonly 'color.background.accent.teal.subtler': 'var(--ds-background-accent-teal-subtler)';
	readonly 'color.background.accent.teal.subtler.hovered': 'var(--ds-background-accent-teal-subtler-hovered)';
	readonly 'color.background.accent.teal.subtler.pressed': 'var(--ds-background-accent-teal-subtler-pressed)';
	readonly 'color.background.accent.teal.subtle': 'var(--ds-background-accent-teal-subtle)';
	readonly 'color.background.accent.teal.subtle.hovered': 'var(--ds-background-accent-teal-subtle-hovered)';
	readonly 'color.background.accent.teal.subtle.pressed': 'var(--ds-background-accent-teal-subtle-pressed)';
	readonly 'color.background.accent.teal.bolder': 'var(--ds-background-accent-teal-bolder)';
	readonly 'color.background.accent.teal.bolder.hovered': 'var(--ds-background-accent-teal-bolder-hovered)';
	readonly 'color.background.accent.teal.bolder.pressed': 'var(--ds-background-accent-teal-bolder-pressed)';
	readonly 'color.background.accent.blue.subtlest': 'var(--ds-background-accent-blue-subtlest)';
	readonly 'color.background.accent.blue.subtlest.hovered': 'var(--ds-background-accent-blue-subtlest-hovered)';
	readonly 'color.background.accent.blue.subtlest.pressed': 'var(--ds-background-accent-blue-subtlest-pressed)';
	readonly 'color.background.accent.blue.subtler': 'var(--ds-background-accent-blue-subtler)';
	readonly 'color.background.accent.blue.subtler.hovered': 'var(--ds-background-accent-blue-subtler-hovered)';
	readonly 'color.background.accent.blue.subtler.pressed': 'var(--ds-background-accent-blue-subtler-pressed)';
	readonly 'color.background.accent.blue.subtle': 'var(--ds-background-accent-blue-subtle)';
	readonly 'color.background.accent.blue.subtle.hovered': 'var(--ds-background-accent-blue-subtle-hovered)';
	readonly 'color.background.accent.blue.subtle.pressed': 'var(--ds-background-accent-blue-subtle-pressed)';
	readonly 'color.background.accent.blue.bolder': 'var(--ds-background-accent-blue-bolder)';
	readonly 'color.background.accent.blue.bolder.hovered': 'var(--ds-background-accent-blue-bolder-hovered)';
	readonly 'color.background.accent.blue.bolder.pressed': 'var(--ds-background-accent-blue-bolder-pressed)';
	readonly 'color.background.accent.purple.subtlest': 'var(--ds-background-accent-purple-subtlest)';
	readonly 'color.background.accent.purple.subtlest.hovered': 'var(--ds-background-accent-purple-subtlest-hovered)';
	readonly 'color.background.accent.purple.subtlest.pressed': 'var(--ds-background-accent-purple-subtlest-pressed)';
	readonly 'color.background.accent.purple.subtler': 'var(--ds-background-accent-purple-subtler)';
	readonly 'color.background.accent.purple.subtler.hovered': 'var(--ds-background-accent-purple-subtler-hovered)';
	readonly 'color.background.accent.purple.subtler.pressed': 'var(--ds-background-accent-purple-subtler-pressed)';
	readonly 'color.background.accent.purple.subtle': 'var(--ds-background-accent-purple-subtle)';
	readonly 'color.background.accent.purple.subtle.hovered': 'var(--ds-background-accent-purple-subtle-hovered)';
	readonly 'color.background.accent.purple.subtle.pressed': 'var(--ds-background-accent-purple-subtle-pressed)';
	readonly 'color.background.accent.purple.bolder': 'var(--ds-background-accent-purple-bolder)';
	readonly 'color.background.accent.purple.bolder.hovered': 'var(--ds-background-accent-purple-bolder-hovered)';
	readonly 'color.background.accent.purple.bolder.pressed': 'var(--ds-background-accent-purple-bolder-pressed)';
	readonly 'color.background.accent.magenta.subtlest': 'var(--ds-background-accent-magenta-subtlest)';
	readonly 'color.background.accent.magenta.subtlest.hovered': 'var(--ds-background-accent-magenta-subtlest-hovered)';
	readonly 'color.background.accent.magenta.subtlest.pressed': 'var(--ds-background-accent-magenta-subtlest-pressed)';
	readonly 'color.background.accent.magenta.subtler': 'var(--ds-background-accent-magenta-subtler)';
	readonly 'color.background.accent.magenta.subtler.hovered': 'var(--ds-background-accent-magenta-subtler-hovered)';
	readonly 'color.background.accent.magenta.subtler.pressed': 'var(--ds-background-accent-magenta-subtler-pressed)';
	readonly 'color.background.accent.magenta.subtle': 'var(--ds-background-accent-magenta-subtle)';
	readonly 'color.background.accent.magenta.subtle.hovered': 'var(--ds-background-accent-magenta-subtle-hovered)';
	readonly 'color.background.accent.magenta.subtle.pressed': 'var(--ds-background-accent-magenta-subtle-pressed)';
	readonly 'color.background.accent.magenta.bolder': 'var(--ds-background-accent-magenta-bolder)';
	readonly 'color.background.accent.magenta.bolder.hovered': 'var(--ds-background-accent-magenta-bolder-hovered)';
	readonly 'color.background.accent.magenta.bolder.pressed': 'var(--ds-background-accent-magenta-bolder-pressed)';
	readonly 'color.background.accent.gray.subtlest': 'var(--ds-background-accent-gray-subtlest)';
	readonly 'color.background.accent.gray.subtlest.hovered': 'var(--ds-background-accent-gray-subtlest-hovered)';
	readonly 'color.background.accent.gray.subtlest.pressed': 'var(--ds-background-accent-gray-subtlest-pressed)';
	readonly 'color.background.accent.gray.subtler': 'var(--ds-background-accent-gray-subtler)';
	readonly 'color.background.accent.gray.subtler.hovered': 'var(--ds-background-accent-gray-subtler-hovered)';
	readonly 'color.background.accent.gray.subtler.pressed': 'var(--ds-background-accent-gray-subtler-pressed)';
	readonly 'color.background.accent.gray.subtle': 'var(--ds-background-accent-gray-subtle)';
	readonly 'color.background.accent.gray.subtle.hovered': 'var(--ds-background-accent-gray-subtle-hovered)';
	readonly 'color.background.accent.gray.subtle.pressed': 'var(--ds-background-accent-gray-subtle-pressed)';
	readonly 'color.background.accent.gray.bolder': 'var(--ds-background-accent-gray-bolder)';
	readonly 'color.background.accent.gray.bolder.hovered': 'var(--ds-background-accent-gray-bolder-hovered)';
	readonly 'color.background.accent.gray.bolder.pressed': 'var(--ds-background-accent-gray-bolder-pressed)';
	readonly 'color.background.disabled': 'var(--ds-background-disabled)';
	readonly 'color.background.input': 'var(--ds-background-input)';
	readonly 'color.background.input.hovered': 'var(--ds-background-input-hovered)';
	readonly 'color.background.input.pressed': 'var(--ds-background-input-pressed)';
	readonly 'color.background.inverse.subtle': 'var(--ds-background-inverse-subtle)';
	readonly 'color.background.inverse.subtle.hovered': 'var(--ds-background-inverse-subtle-hovered)';
	readonly 'color.background.inverse.subtle.pressed': 'var(--ds-background-inverse-subtle-pressed)';
	readonly 'color.background.neutral': 'var(--ds-background-neutral)';
	readonly 'color.background.neutral.hovered': 'var(--ds-background-neutral-hovered)';
	readonly 'color.background.neutral.pressed': 'var(--ds-background-neutral-pressed)';
	readonly 'color.background.neutral.subtle': 'var(--ds-background-neutral-subtle)';
	readonly 'color.background.neutral.subtle.hovered': 'var(--ds-background-neutral-subtle-hovered)';
	readonly 'color.background.neutral.subtle.pressed': 'var(--ds-background-neutral-subtle-pressed)';
	readonly 'color.background.neutral.bold': 'var(--ds-background-neutral-bold)';
	readonly 'color.background.neutral.bold.hovered': 'var(--ds-background-neutral-bold-hovered)';
	readonly 'color.background.neutral.bold.pressed': 'var(--ds-background-neutral-bold-pressed)';
	readonly 'color.background.selected': 'var(--ds-background-selected)';
	readonly 'color.background.selected.hovered': 'var(--ds-background-selected-hovered)';
	readonly 'color.background.selected.pressed': 'var(--ds-background-selected-pressed)';
	readonly 'color.background.selected.bold': 'var(--ds-background-selected-bold)';
	readonly 'color.background.selected.bold.hovered': 'var(--ds-background-selected-bold-hovered)';
	readonly 'color.background.selected.bold.pressed': 'var(--ds-background-selected-bold-pressed)';
	readonly 'color.background.brand.subtlest': 'var(--ds-background-brand-subtlest)';
	readonly 'color.background.brand.subtlest.hovered': 'var(--ds-background-brand-subtlest-hovered)';
	readonly 'color.background.brand.subtlest.pressed': 'var(--ds-background-brand-subtlest-pressed)';
	readonly 'color.background.brand.bold': 'var(--ds-background-brand-bold)';
	readonly 'color.background.brand.bold.hovered': 'var(--ds-background-brand-bold-hovered)';
	readonly 'color.background.brand.bold.pressed': 'var(--ds-background-brand-bold-pressed)';
	readonly 'color.background.brand.boldest': 'var(--ds-background-brand-boldest)';
	readonly 'color.background.brand.boldest.hovered': 'var(--ds-background-brand-boldest-hovered)';
	readonly 'color.background.brand.boldest.pressed': 'var(--ds-background-brand-boldest-pressed)';
	readonly 'color.background.danger': 'var(--ds-background-danger)';
	readonly 'color.background.danger.hovered': 'var(--ds-background-danger-hovered)';
	readonly 'color.background.danger.pressed': 'var(--ds-background-danger-pressed)';
	readonly 'color.background.danger.bold': 'var(--ds-background-danger-bold)';
	readonly 'color.background.danger.bold.hovered': 'var(--ds-background-danger-bold-hovered)';
	readonly 'color.background.danger.bold.pressed': 'var(--ds-background-danger-bold-pressed)';
	readonly 'color.background.warning': 'var(--ds-background-warning)';
	readonly 'color.background.warning.hovered': 'var(--ds-background-warning-hovered)';
	readonly 'color.background.warning.pressed': 'var(--ds-background-warning-pressed)';
	readonly 'color.background.warning.bold': 'var(--ds-background-warning-bold)';
	readonly 'color.background.warning.bold.hovered': 'var(--ds-background-warning-bold-hovered)';
	readonly 'color.background.warning.bold.pressed': 'var(--ds-background-warning-bold-pressed)';
	readonly 'color.background.success': 'var(--ds-background-success)';
	readonly 'color.background.success.hovered': 'var(--ds-background-success-hovered)';
	readonly 'color.background.success.pressed': 'var(--ds-background-success-pressed)';
	readonly 'color.background.success.bold': 'var(--ds-background-success-bold)';
	readonly 'color.background.success.bold.hovered': 'var(--ds-background-success-bold-hovered)';
	readonly 'color.background.success.bold.pressed': 'var(--ds-background-success-bold-pressed)';
	readonly 'color.background.discovery': 'var(--ds-background-discovery)';
	readonly 'color.background.discovery.hovered': 'var(--ds-background-discovery-hovered)';
	readonly 'color.background.discovery.pressed': 'var(--ds-background-discovery-pressed)';
	readonly 'color.background.discovery.bold': 'var(--ds-background-discovery-bold)';
	readonly 'color.background.discovery.bold.hovered': 'var(--ds-background-discovery-bold-hovered)';
	readonly 'color.background.discovery.bold.pressed': 'var(--ds-background-discovery-bold-pressed)';
	readonly 'color.background.information': 'var(--ds-background-information)';
	readonly 'color.background.information.hovered': 'var(--ds-background-information-hovered)';
	readonly 'color.background.information.pressed': 'var(--ds-background-information-pressed)';
	readonly 'color.background.information.bold': 'var(--ds-background-information-bold)';
	readonly 'color.background.information.bold.hovered': 'var(--ds-background-information-bold-hovered)';
	readonly 'color.background.information.bold.pressed': 'var(--ds-background-information-bold-pressed)';
	readonly 'color.blanket': 'var(--ds-blanket)';
	readonly 'color.blanket.selected': 'var(--ds-blanket-selected)';
	readonly 'color.blanket.danger': 'var(--ds-blanket-danger)';
	readonly 'elevation.surface': 'var(--ds-surface)';
	readonly 'elevation.surface.hovered': 'var(--ds-surface-hovered)';
	readonly 'elevation.surface.pressed': 'var(--ds-surface-pressed)';
	readonly 'elevation.surface.overlay': 'var(--ds-surface-overlay)';
	readonly 'elevation.surface.overlay.hovered': 'var(--ds-surface-overlay-hovered)';
	readonly 'elevation.surface.overlay.pressed': 'var(--ds-surface-overlay-pressed)';
	readonly 'elevation.surface.raised': 'var(--ds-surface-raised)';
	readonly 'elevation.surface.raised.hovered': 'var(--ds-surface-raised-hovered)';
	readonly 'elevation.surface.raised.pressed': 'var(--ds-surface-raised-pressed)';
	readonly 'elevation.surface.sunken': 'var(--ds-surface-sunken)';
	readonly 'utility.elevation.surface.current': 'var(--ds-elevation-surface-current)';
};

// @public (undocumented)
type BaseBoxProps<T extends CustomElementType> = {
	as?: T;
	children?: ReactNode;
	backgroundColor?: BackgroundColor;
	padding?: Space;
	paddingBlock?: Space;
	paddingBlockStart?: Space;
	paddingBlockEnd?: Space;
	paddingInline?: Space;
	paddingInlineStart?: Space;
	paddingInlineEnd?: Space;
	ref?: ComponentPropsWithRef<T>['ref'];
};

// @public (undocumented)
type BasePrimitiveProps = {
	testId?: string;
	xcss?: Array<XCSS | false | undefined> | XCSS;
	role?: string;
};

// @public
export const Bleed: MemoExoticComponent<
	({ children, testId, inline, block, all, xcss }: BleedProps) => jsx.JSX.Element
>;

// @public (undocumented)
export type BleedProps = {
	children: ReactNode;
	all?: Space_2;
	inline?: Space_2;
	block?: Space_2;
} & BasePrimitiveProps;

// @public (undocumented)
type BodyText = keyof typeof bodyTextMap;

// @public (undocumented)
const bodyTextMap: {
	body: 'var(--ds-font-body)';
	'body.large': 'var(--ds-font-body-large)';
	'body.small': 'var(--ds-font-body-small)';
};

// @public (undocumented)
export type BorderColor = keyof typeof borderColorMap;

// @public
const borderColorMap: {
	readonly 'color.border': 'var(--ds-border)';
	readonly 'color.border.accent.lime': 'var(--ds-border-accent-lime)';
	readonly 'color.border.accent.red': 'var(--ds-border-accent-red)';
	readonly 'color.border.accent.orange': 'var(--ds-border-accent-orange)';
	readonly 'color.border.accent.yellow': 'var(--ds-border-accent-yellow)';
	readonly 'color.border.accent.green': 'var(--ds-border-accent-green)';
	readonly 'color.border.accent.teal': 'var(--ds-border-accent-teal)';
	readonly 'color.border.accent.blue': 'var(--ds-border-accent-blue)';
	readonly 'color.border.accent.purple': 'var(--ds-border-accent-purple)';
	readonly 'color.border.accent.magenta': 'var(--ds-border-accent-magenta)';
	readonly 'color.border.accent.gray': 'var(--ds-border-accent-gray)';
	readonly 'color.border.disabled': 'var(--ds-border-disabled)';
	readonly 'color.border.focused': 'var(--ds-border-focused)';
	readonly 'color.border.input': 'var(--ds-border-input)';
	readonly 'color.border.inverse': 'var(--ds-border-inverse)';
	readonly 'color.border.selected': 'var(--ds-border-selected)';
	readonly 'color.border.brand': 'var(--ds-border-brand)';
	readonly 'color.border.danger': 'var(--ds-border-danger)';
	readonly 'color.border.warning': 'var(--ds-border-warning)';
	readonly 'color.border.success': 'var(--ds-border-success)';
	readonly 'color.border.discovery': 'var(--ds-border-discovery)';
	readonly 'color.border.information': 'var(--ds-border-information)';
	readonly 'color.border.bold': 'var(--ds-border-bold)';
};

// @public (undocumented)
export type BorderRadius = keyof typeof borderRadiusMap;

// @public (undocumented)
const borderRadiusMap: {
	readonly 'border.radius.050': 'var(--ds-border-radius-050)';
	readonly 'border.radius': 'var(--ds-border-radius)';
	readonly 'border.radius.100': 'var(--ds-border-radius-100)';
	readonly 'border.radius.200': 'var(--ds-border-radius-200)';
	readonly 'border.radius.300': 'var(--ds-border-radius-300)';
	readonly 'border.radius.400': 'var(--ds-border-radius-400)';
	readonly 'border.radius.circle': 'var(--ds-border-radius-circle)';
};

// @public (undocumented)
export type BorderWidth = keyof typeof borderWidthMap;

// @public
const borderWidthMap: {
	readonly 'border.width': 'var(--ds-border-width)';
	readonly 'border.width.0': 'var(--ds-border-width-0)';
	readonly 'border.width.indicator': 'var(--ds-border-width-indicator)';
	readonly 'border.width.outline': 'var(--ds-border-width-outline)';
};

// @public
export const Box: BoxComponent;

// @public (undocumented)
type BoxComponent = <T extends CustomElementType>(props: BoxProps<T>) => ReactElement | null;

// @public (undocumented)
export type BoxProps<T extends CustomElementType> = Omit<
	ComponentPropsWithoutRef<T>,
	'as' | 'className'
> &
	BasePrimitiveProps &
	StyleProp &
	BaseBoxProps<T>;

// @public
export type Breakpoint = 'lg' | 'md' | 'sm' | 'xl' | 'xs' | 'xxs';

// @public (undocumented)
type CSSAtRules = {
	[AtRule in AtRulesWithoutMedia as `${AtRule}${string}`]?: Omit<
		SafeCSSObject,
		AtRulesWithoutMedia
	>;
};

// @public (undocumented)
type CSSMediaQueries = {
	[MQ in AllMedia]?: Omit<SafeCSSObject, AllMedia>;
};

// @public (undocumented)
type CSSPseudos = {
	[Pseudo in CSS_2.Pseudos]?: Omit<SafeCSSObject, AllMedia | CSS_2.Pseudos>;
};

// @public (undocumented)
type CustomElementType<P = any> = {
	[K in AllowedElements]: P extends JSX.IntrinsicElements[K] ? K : never;
}[AllowedElements];

// @public (undocumented)
export type Dimension = keyof typeof dimensionMap;

// @public
const dimensionMap: {
	readonly '100%': '100%';
	readonly 'size.100': '1rem';
	readonly 'size.200': '1.5rem';
	readonly 'size.300': '2rem';
	readonly 'size.400': '2.5rem';
	readonly 'size.500': '3rem';
	readonly 'size.600': '6rem';
	readonly 'size.1000': '12rem';
};

// @public (undocumented)
type Direction = keyof typeof flexDirectionMap;

// @public
export const Flex: MemoExoticComponent<
	ForwardRefExoticComponent<
		Pick<
			{
				as?: 'div' | 'li' | 'ol' | 'span' | 'ul' | undefined;
				justifyContent?:
					| 'center'
					| 'end'
					| 'space-around'
					| 'space-between'
					| 'space-evenly'
					| 'start'
					| 'stretch'
					| undefined;
				alignItems?: 'baseline' | 'center' | 'end' | 'start' | 'stretch' | undefined;
				columnGap?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				gap?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				rowGap?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				direction?: 'column' | 'row' | undefined;
				wrap?: 'nowrap' | 'wrap' | undefined;
				children: ReactNode;
				ref?: any;
			} & BasePrimitiveProps,
			| 'alignItems'
			| 'as'
			| 'children'
			| 'columnGap'
			| 'direction'
			| 'gap'
			| 'justifyContent'
			| 'rowGap'
			| 'wrap'
			| keyof BasePrimitiveProps
		> &
			RefAttributes<any>
	>
>;

// @public (undocumented)
const flexDirectionMap: {
	readonly column: SerializedStyles_2;
	readonly row: SerializedStyles_2;
};

// @public (undocumented)
export type FlexProps<T extends ElementType = 'div'> = {
	as?: 'div' | 'li' | 'ol' | 'span' | 'ul';
	justifyContent?: JustifyContent;
	alignItems?: AlignItems;
	columnGap?: Space;
	gap?: Space;
	rowGap?: Space;
	direction?: Direction;
	wrap?: Wrap;
	children: ReactNode;
	ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;

// @public (undocumented)
const flexWrapMap: {
	readonly wrap: SerializedStyles_2;
	readonly nowrap: SerializedStyles_2;
};

// @public
export const Grid: MemoExoticComponent<
	ForwardRefExoticComponent<
		Pick<
			{
				as?: 'div' | 'ol' | 'span' | 'ul' | undefined;
				justifyContent?:
					| 'center'
					| 'end'
					| 'space-around'
					| 'space-between'
					| 'space-evenly'
					| 'start'
					| 'stretch'
					| undefined;
				justifyItems?: 'center' | 'end' | 'start' | 'stretch' | undefined;
				alignItems?: 'baseline' | 'center' | 'end' | 'start' | undefined;
				alignContent?:
					| 'center'
					| 'end'
					| 'space-around'
					| 'space-between'
					| 'space-evenly'
					| 'start'
					| 'stretch'
					| undefined;
				columnGap?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				gap?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				rowGap?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				autoFlow?: 'column dense' | 'column' | 'dense' | 'row dense' | 'row' | undefined;
				templateRows?: string | undefined;
				templateColumns?: string | undefined;
				templateAreas?: string[] | undefined;
				children: ReactNode;
				id?: string | undefined;
				ref?: any;
			} & BasePrimitiveProps,
			| 'alignContent'
			| 'alignItems'
			| 'as'
			| 'autoFlow'
			| 'children'
			| 'columnGap'
			| 'gap'
			| 'id'
			| 'justifyContent'
			| 'justifyItems'
			| 'rowGap'
			| 'templateAreas'
			| 'templateColumns'
			| 'templateRows'
			| keyof BasePrimitiveProps
		> &
			RefAttributes<any>
	>
>;

// @public (undocumented)
const gridAutoFlowMap: {
	readonly row: SerializedStyles_2;
	readonly column: SerializedStyles_2;
	readonly dense: SerializedStyles_2;
	readonly 'row dense': SerializedStyles_2;
	readonly 'column dense': SerializedStyles_2;
};

// @public (undocumented)
export type GridProps<T extends ElementType = 'div'> = {
	as?: 'div' | 'ol' | 'span' | 'ul';
	justifyContent?: JustifyContent_2;
	justifyItems?: JustifyItems;
	alignItems?: AlignItems_2;
	alignContent?: AlignContent;
	columnGap?: Space;
	gap?: Space;
	rowGap?: Space;
	autoFlow?: AutoFlow;
	templateRows?: string;
	templateColumns?: string;
	templateAreas?: string[];
	children: ReactNode;
	id?: string;
	ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;

// @public (undocumented)
type Grow = 'fill' | 'hug';

// @public
export const Inline: MemoExoticComponent<
	ForwardRefExoticComponent<
		Pick<
			{
				as?: 'div' | 'li' | 'ol' | 'span' | 'ul' | undefined;
				alignBlock?: AlignBlock | undefined;
				alignInline?: AlignInline | undefined;
				shouldWrap?: boolean | undefined;
				spread?: 'space-between' | undefined;
				grow?: Grow | undefined;
				space?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				rowSpace?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				separator?: string | undefined;
				children: ReactNode;
				ref?: any;
			} & BasePrimitiveProps,
			| 'alignBlock'
			| 'alignInline'
			| 'as'
			| 'children'
			| 'grow'
			| 'rowSpace'
			| 'separator'
			| 'shouldWrap'
			| 'space'
			| 'spread'
			| keyof BasePrimitiveProps
		> &
			RefAttributes<any>
	>
>;

// @public (undocumented)
export type InlineProps<T extends ElementType = 'div'> = {
	as?: 'div' | 'li' | 'ol' | 'span' | 'ul';
	alignBlock?: AlignBlock;
	alignInline?: AlignInline;
	shouldWrap?: boolean;
	spread?: Spread;
	grow?: Grow;
	space?: Space;
	rowSpace?: Space;
	separator?: string;
	children: ReactNode;
	ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;

// @public (undocumented)
type JustifyContent = keyof typeof justifyContentMap;

// @public (undocumented)
type JustifyContent_2 = keyof typeof justifyContentMap_2;

// @public (undocumented)
const justifyContentMap: {
	readonly start: SerializedStyles_2;
	readonly center: SerializedStyles_2;
	readonly end: SerializedStyles_2;
	readonly 'space-between': SerializedStyles_2;
	readonly 'space-around': SerializedStyles_2;
	readonly 'space-evenly': SerializedStyles_2;
	readonly stretch: SerializedStyles_2;
};

// @public (undocumented)
const justifyContentMap_2: {
	readonly start: SerializedStyles_2;
	readonly center: SerializedStyles_2;
	readonly end: SerializedStyles_2;
	readonly 'space-between': SerializedStyles_2;
	readonly 'space-around': SerializedStyles_2;
	readonly 'space-evenly': SerializedStyles_2;
	readonly stretch: SerializedStyles_2;
};

// @public (undocumented)
type JustifyItems = keyof typeof justifyItemsMap;

// @public (undocumented)
const justifyItemsMap: {
	readonly start: SerializedStyles_2;
	readonly center: SerializedStyles_2;
	readonly end: SerializedStyles_2;
	readonly stretch: SerializedStyles_2;
};

// @public (undocumented)
export type Layer = keyof typeof layerMap;

// @public
const layerMap: {
	readonly card: 100;
	readonly navigation: 200;
	readonly dialog: 300;
	readonly layer: 400;
	readonly blanket: 500;
	readonly modal: 510;
	readonly flag: 600;
	readonly spotlight: 700;
	readonly tooltip: 800;
};

// @public (undocumented)
type MarginSpace = 'auto' | NegativeSpace | Space;

// @public
export const media: SafeMedia;

// @public
type MediaQuery = (typeof media.above)[Breakpoint];

// @public (undocumented)
type NegativeSpace = keyof typeof negativeSpaceMap;

// @public (undocumented)
const negativeSpaceMap: {
	'space.negative.025': 'var(--ds-space-negative-025)';
	'space.negative.050': 'var(--ds-space-negative-050)';
	'space.negative.075': 'var(--ds-space-negative-075)';
	'space.negative.100': 'var(--ds-space-negative-100)';
	'space.negative.150': 'var(--ds-space-negative-150)';
	'space.negative.200': 'var(--ds-space-negative-200)';
	'space.negative.250': 'var(--ds-space-negative-250)';
	'space.negative.300': 'var(--ds-space-negative-300)';
	'space.negative.400': 'var(--ds-space-negative-400)';
};

// @public (undocumented)
type Opacity = keyof typeof opacityMap;

// @public
const opacityMap: {
	readonly 'opacity.disabled': 'var(--ds-opacity-disabled)';
	readonly 'opacity.loading': 'var(--ds-opacity-loading)';
};

// @public (undocumented)
type SafeCSSObject = CSSPseudos &
	CSSAtRules &
	TokenisedProps &
	CSSMediaQueries &
	Omit<CSSPropertiesWithMultiValues, keyof TokenisedProps>;

// @public
type SafeMedia = Pick<typeof UNSAFE_media, 'above'>;

// @public (undocumented)
export type Shadow = keyof typeof shadowMap;

// @public (undocumented)
const shadowMap: {
	readonly 'elevation.shadow.overflow': 'var(--ds-shadow-overflow)';
	readonly 'elevation.shadow.overflow.perimeter': 'var(--ds-shadow-overflow-perimeter)';
	readonly 'elevation.shadow.overflow.spread': 'var(--ds-shadow-overflow-spread)';
	readonly 'elevation.shadow.overlay': 'var(--ds-shadow-overlay)';
	readonly 'elevation.shadow.raised': 'var(--ds-shadow-raised)';
};

// @public (undocumented)
export type Space = keyof typeof spaceMap;

// @public (undocumented)
type Space_2 = 'space.025' | 'space.050' | 'space.100' | 'space.150' | 'space.200';

// @public
const spaceMap: {
	'space.0': 'var(--ds-space-0)';
	'space.025': 'var(--ds-space-025)';
	'space.050': 'var(--ds-space-050)';
	'space.075': 'var(--ds-space-075)';
	'space.100': 'var(--ds-space-100)';
	'space.150': 'var(--ds-space-150)';
	'space.200': 'var(--ds-space-200)';
	'space.250': 'var(--ds-space-250)';
	'space.300': 'var(--ds-space-300)';
	'space.400': 'var(--ds-space-400)';
	'space.500': 'var(--ds-space-500)';
	'space.600': 'var(--ds-space-600)';
	'space.800': 'var(--ds-space-800)';
	'space.1000': 'var(--ds-space-1000)';
};

// @public (undocumented)
type Spread = 'space-between';

// @public
export const Stack: MemoExoticComponent<
	ForwardRefExoticComponent<
		Pick<
			{
				as?: 'div' | 'ol' | 'span' | 'ul' | undefined;
				alignBlock?: 'center' | 'end' | 'start' | 'stretch' | undefined;
				alignInline?: AlignInline | undefined;
				spread?: 'space-between' | undefined;
				grow?: Grow | undefined;
				space?:
					| 'space.0'
					| 'space.025'
					| 'space.050'
					| 'space.075'
					| 'space.100'
					| 'space.1000'
					| 'space.150'
					| 'space.200'
					| 'space.250'
					| 'space.300'
					| 'space.400'
					| 'space.500'
					| 'space.600'
					| 'space.800'
					| undefined;
				children: ReactNode;
				ref?: any;
			} & BasePrimitiveProps,
			| 'alignBlock'
			| 'alignInline'
			| 'as'
			| 'children'
			| 'grow'
			| 'space'
			| 'spread'
			| keyof BasePrimitiveProps
		> &
			RefAttributes<any>
	>
>;

// @public (undocumented)
export type StackProps<T extends ElementType = 'div'> = {
	as?: 'div' | 'ol' | 'span' | 'ul';
	alignBlock?: Exclude<AlignBlock, 'baseline'>;
	alignInline?: AlignInline;
	spread?: Spread;
	grow?: Grow;
	space?: Space;
	children: ReactNode;
	ref?: React.ComponentPropsWithRef<T>['ref'];
} & BasePrimitiveProps;

// @public (undocumented)
type StyleProp = {
	style?: CSSProperties;
};

// @public (undocumented)
type SVGElements =
	| 'animate'
	| 'animateMotion'
	| 'animateTransform'
	| 'circle'
	| 'clipPath'
	| 'defs'
	| 'desc'
	| 'ellipse'
	| 'feBlend'
	| 'feColorMatrix'
	| 'feComponentTransfer'
	| 'feComposite'
	| 'feConvolveMatrix'
	| 'feDiffuseLighting'
	| 'feDisplacementMap'
	| 'feDistantLight'
	| 'feDropShadow'
	| 'feFlood'
	| 'feFuncA'
	| 'feFuncB'
	| 'feFuncG'
	| 'feFuncR'
	| 'feGaussianBlur'
	| 'feImage'
	| 'feMerge'
	| 'feMergeNode'
	| 'feMorphology'
	| 'feOffset'
	| 'fePointLight'
	| 'feSpecularLighting'
	| 'feSpotLight'
	| 'feTile'
	| 'feTurbulence'
	| 'filter'
	| 'foreignObject'
	| 'g'
	| 'image'
	| 'line'
	| 'linearGradient'
	| 'marker'
	| 'mask'
	| 'metadata'
	| 'mpath'
	| 'path'
	| 'pattern'
	| 'polygon'
	| 'polyline'
	| 'radialGradient'
	| 'rect'
	| 'stop'
	| 'svg'
	| 'switch'
	| 'symbol'
	| 'text'
	| 'textPath'
	| 'tspan'
	| 'use'
	| 'view';

// @internal
const Text_2: FC<TextProps>;
export { Text_2 as Text };

// @public (undocumented)
type TextAlign = keyof typeof textAlignMap;

// @public (undocumented)
const textAlignMap: {
	center: SerializedStyles_2;
	end: SerializedStyles_2;
	start: SerializedStyles_2;
};

// @public (undocumented)
export type TextColor = keyof typeof textColorMap;

// @public (undocumented)
const textColorMap: {
	readonly 'color.text': 'var(--ds-text)';
	readonly 'color.text.accent.lime': 'var(--ds-text-accent-lime)';
	readonly 'color.text.accent.lime.bolder': 'var(--ds-text-accent-lime-bolder)';
	readonly 'color.text.accent.red': 'var(--ds-text-accent-red)';
	readonly 'color.text.accent.red.bolder': 'var(--ds-text-accent-red-bolder)';
	readonly 'color.text.accent.orange': 'var(--ds-text-accent-orange)';
	readonly 'color.text.accent.orange.bolder': 'var(--ds-text-accent-orange-bolder)';
	readonly 'color.text.accent.yellow': 'var(--ds-text-accent-yellow)';
	readonly 'color.text.accent.yellow.bolder': 'var(--ds-text-accent-yellow-bolder)';
	readonly 'color.text.accent.green': 'var(--ds-text-accent-green)';
	readonly 'color.text.accent.green.bolder': 'var(--ds-text-accent-green-bolder)';
	readonly 'color.text.accent.teal': 'var(--ds-text-accent-teal)';
	readonly 'color.text.accent.teal.bolder': 'var(--ds-text-accent-teal-bolder)';
	readonly 'color.text.accent.blue': 'var(--ds-text-accent-blue)';
	readonly 'color.text.accent.blue.bolder': 'var(--ds-text-accent-blue-bolder)';
	readonly 'color.text.accent.purple': 'var(--ds-text-accent-purple)';
	readonly 'color.text.accent.purple.bolder': 'var(--ds-text-accent-purple-bolder)';
	readonly 'color.text.accent.magenta': 'var(--ds-text-accent-magenta)';
	readonly 'color.text.accent.magenta.bolder': 'var(--ds-text-accent-magenta-bolder)';
	readonly 'color.text.accent.gray': 'var(--ds-text-accent-gray)';
	readonly 'color.text.accent.gray.bolder': 'var(--ds-text-accent-gray-bolder)';
	readonly 'color.text.disabled': 'var(--ds-text-disabled)';
	readonly 'color.text.inverse': 'var(--ds-text-inverse)';
	readonly 'color.text.selected': 'var(--ds-text-selected)';
	readonly 'color.text.brand': 'var(--ds-text-brand)';
	readonly 'color.text.danger': 'var(--ds-text-danger)';
	readonly 'color.text.warning': 'var(--ds-text-warning)';
	readonly 'color.text.warning.inverse': 'var(--ds-text-warning-inverse)';
	readonly 'color.text.success': 'var(--ds-text-success)';
	readonly 'color.text.discovery': 'var(--ds-text-discovery)';
	readonly 'color.text.information': 'var(--ds-text-information)';
	readonly 'color.text.subtlest': 'var(--ds-text-subtlest)';
	readonly 'color.text.subtle': 'var(--ds-text-subtle)';
	readonly 'color.link': 'var(--ds-link)';
	readonly 'color.link.pressed': 'var(--ds-link-pressed)';
	readonly 'color.link.visited': 'var(--ds-link-visited)';
};

// @public (undocumented)
export interface TextProps extends BasePrimitiveProps {
	as?: AsElement;
	children: ReactNode;
	color?: TextColor;
	id?: string;
	shouldTruncate?: boolean;
	textAlign?: TextAlign;
	variant?: Variant;
}

// @public (undocumented)
type TokenisedProps = {
	backgroundColor?: BackgroundColor;
	blockSize?: AutoComplete<Dimension>;
	borderBlockColor?: AutoComplete<BorderColor>;
	borderBlockEndColor?: AutoComplete<BorderColor>;
	borderBlockEndWidth?: AutoComplete<BorderWidth>;
	borderBlockStartColor?: AutoComplete<BorderColor>;
	borderBlockStartWidth?: AutoComplete<BorderWidth>;
	borderBlockWidth?: AutoComplete<BorderWidth>;
	borderBottomColor?: AutoComplete<BorderColor>;
	borderBottomLeftRadius?: AutoComplete<BorderRadius>;
	borderBottomRightRadius?: AutoComplete<BorderRadius>;
	borderBottomWidth?: AutoComplete<BorderWidth>;
	borderColor?: BorderColor;
	borderEndEndRadius?: AutoComplete<BorderRadius>;
	borderEndStartRadius?: AutoComplete<BorderRadius>;
	borderInlineColor?: AutoComplete<BorderColor>;
	borderInlineEndColor?: AutoComplete<BorderColor>;
	borderInlineEndWidth?: AutoComplete<BorderWidth>;
	borderInlineStartColor?: AutoComplete<BorderColor>;
	borderInlineStartWidth?: AutoComplete<BorderWidth>;
	borderInlineWidth?: AutoComplete<BorderWidth>;
	borderLeftColor?: AutoComplete<BorderColor>;
	borderLeftWidth?: AutoComplete<BorderWidth>;
	borderRadius?: BorderRadius;
	borderRightColor?: AutoComplete<BorderColor>;
	borderRightWidth?: AutoComplete<BorderWidth>;
	borderStartEndRadius?: AutoComplete<BorderRadius>;
	borderStartStartRadius?: AutoComplete<BorderRadius>;
	borderTopColor?: AutoComplete<BorderColor>;
	borderTopLeftRadius?: AutoComplete<BorderRadius>;
	borderTopRightRadius?: AutoComplete<BorderRadius>;
	borderTopWidth?: AutoComplete<BorderWidth>;
	borderWidth?: BorderWidth;
	bottom?: AutoComplete<Space>;
	boxShadow?: Shadow;
	color?: TextColor;
	columnGap?: Space;
	gap?: Space;
	height?: AutoComplete<Dimension>;
	inlineSize?: AutoComplete<Dimension>;
	inset?: Space;
	insetBlock?: Space;
	insetBlockEnd?: Space;
	insetBlockStart?: Space;
	insetInline?: Space;
	insetInlineEnd?: Space;
	insetInlineStart?: Space;
	left?: AutoComplete<Space>;
	margin?: AutoComplete<MarginSpace>;
	marginBlock?: AutoComplete<MarginSpace>;
	marginBlockEnd?: AutoComplete<MarginSpace>;
	marginBlockStart?: AutoComplete<MarginSpace>;
	marginBottom?: AutoComplete<MarginSpace>;
	marginInline?: AutoComplete<MarginSpace>;
	marginInlineEnd?: AutoComplete<MarginSpace>;
	marginInlineStart?: AutoComplete<MarginSpace>;
	marginLeft?: AutoComplete<MarginSpace>;
	marginRight?: AutoComplete<MarginSpace>;
	marginTop?: AutoComplete<MarginSpace>;
	maxBlockSize?: AutoComplete<Dimension>;
	maxHeight?: AutoComplete<Dimension>;
	maxInlineSize?: AutoComplete<Dimension>;
	maxWidth?: AutoComplete<Dimension>;
	minBlockSize?: AutoComplete<Dimension>;
	minHeight?: AutoComplete<Dimension>;
	minInlineSize?: AutoComplete<Dimension>;
	minWidth?: AutoComplete<Dimension>;
	opacity?: AutoComplete<Opacity> | number;
	outlineColor?: BorderColor;
	outlineOffset?: Space;
	outlineWidth?: BorderWidth;
	padding?: Space;
	paddingBlock?: Space;
	paddingBlockEnd?: Space;
	paddingBlockStart?: Space;
	paddingBottom?: AutoComplete<Space>;
	paddingInline?: Space;
	paddingInlineEnd?: Space;
	paddingInlineStart?: Space;
	paddingLeft?: AutoComplete<Space>;
	paddingRight?: AutoComplete<Space>;
	paddingTop?: AutoComplete<Space>;
	right?: AutoComplete<Space>;
	rowGap?: Space;
	top?: AutoComplete<Space>;
	width?: AutoComplete<Dimension>;
	zIndex?: Layer;
};

// @public (undocumented)
type UiText = keyof typeof uiTextMap;

// @public (undocumented)
const uiTextMap: {
	ui: 'var(--ds-font-ui)';
	'ui.small': 'var(--ds-font-ui-small)';
};

// @public (undocumented)
const uniqueSymbol: unique symbol;

// @public
export const UNSAFE_BREAKPOINTS_CONFIG: {
	readonly xxs: {
		readonly gridItemGutter: 'var(--ds-space-200)';
		readonly gridMargin: 'var(--ds-space-200)';
		readonly min: '0rem';
		readonly max: '29.99rem';
	};
	readonly xs: {
		readonly gridItemGutter: 'var(--ds-space-200)';
		readonly gridMargin: 'var(--ds-space-200)';
		readonly min: '30rem';
		readonly max: '47.99rem';
	};
	readonly sm: {
		readonly gridItemGutter: 'var(--ds-space-200)';
		readonly gridMargin: 'var(--ds-space-300)';
		readonly min: '48rem';
		readonly max: '63.99rem';
	};
	readonly md: {
		readonly gridItemGutter: 'var(--ds-space-300)';
		readonly gridMargin: 'var(--ds-space-400)';
		readonly min: '64rem';
		readonly max: '89.99rem';
	};
	readonly lg: {
		readonly gridItemGutter: 'var(--ds-space-400)';
		readonly gridMargin: 'var(--ds-space-400)';
		readonly min: '90rem';
		readonly max: '109.99rem';
	};
	readonly xl: {
		readonly gridItemGutter: 'var(--ds-space-400)';
		readonly gridMargin: 'var(--ds-space-500)';
		readonly min: '110rem';
		readonly max: null;
	};
};

// @internal
export const UNSAFE_media: {
	above: {
		readonly xxs: '@media all';
		readonly xs: '@media (min-width: 30rem)';
		readonly sm: '@media (min-width: 48rem)';
		readonly md: '@media (min-width: 64rem)';
		readonly lg: '@media (min-width: 90rem)';
		readonly xl: '@media (min-width: 110rem)';
	};
	below: {
		readonly xs: '@media not all and (min-width: 30rem)';
		readonly sm: '@media not all and (min-width: 48rem)';
		readonly md: '@media not all and (min-width: 64rem)';
		readonly lg: '@media not all and (min-width: 90rem)';
		readonly xl: '@media not all and (min-width: 110rem)';
	};
	only: {
		readonly xxs: '@media (min-width: 0rem) and (max-width: 29.99rem)';
		readonly xs: '@media (min-width: 30rem) and (max-width: 47.99rem)';
		readonly sm: '@media (min-width: 48rem) and (max-width: 63.99rem)';
		readonly md: '@media (min-width: 64rem) and (max-width: 89.99rem)';
		readonly lg: '@media (min-width: 90rem) and (max-width: 109.99rem)';
		readonly xl: '@media (min-width: 110rem)';
	};
};

// @public (undocumented)
type Variant = BodyText | UiText;

// @public (undocumented)
type Wrap = keyof typeof flexWrapMap;

// @public (undocumented)
type XCSS = ReturnType<typeof xcss>;

// @public
export function xcss(style: SafeCSSObject): {
	readonly [uniqueSymbol]: SerializedStyles;
};

// (No @packageDocumentation comment for this package)
```

<!--SECTION END: Main Entry Types-->

### Peer Dependencies

<!--SECTION START: Peer Dependencies-->

```json
{
	"react": "^16.8.0 || ^17.0.0 || ^18.0.0"
}
```

<!--SECTION END: Peer Dependencies-->
