## Global allocator using GrapheneOS allocator

- Released under the same license as the GrapheneOS allocator.
- The major version follows the GrapheneOS allocator version.
- Use it, harden your memories, spread the love!

## Configuration

- Build requires a C17 supporting compiler!
- We follow upstream configuration closely (except `CONFIG_WERROR`).
- Feature `light` enables light mode, otherwise you're in `default` mode.
- Feature `seal` enables `CONFIG_SEAL_METADATA`, noop if target env isn't GNU.
- Feature `small` sets `CONFIG_CLASS_REGION_SIZE` to `4GiB` (default: `32GiB`).
- Feature `tiny` sets `CONFIG_CLASS_REGION_SIZE` to `4MiB`.
- `GlobalAlloc::dealloc` uses hardened allocator extension `free_sized` to
   verify size.

## Example

- Add the following to your `Cargo.toml`.
- Add `features = ["light"]` as necessary.

```
# Default allocator:
# GrapheneOS does not support 32-bit.
[target.'cfg(target_pointer_width = "64")'.dependencies]
hardened-malloc = { version = "13.0.0" }
```

With that in dependencies, you may change your default global allocator:

```
// Set global allocator to GrapheneOS allocator.
#[cfg(target_pointer_width = "64")]
#[global_allocator]
static GLOBAL: hardened_malloc::HardenedMalloc = hardened_malloc::HardenedMalloc;
```

Maintained by Ali Polatel. Up-to-date sources can be found at
https://git.sr.ht/~alip/syd and bugs/patches can be submitted by email to
[~alip/sydbox-devel@lists.sr.ht](mailto:~alip/sydbox-devel@lists.sr.ht).
Exherbo related bugs/issues can be submitted to
<https://gitlab.exherbo.org/groups/sydbox/-/issues>. Discuss in [#sydbox on Libera
Chat](ircs://irc.libera.chat/#sydbox).
