/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.netbeans.api.htmlui.OpenHTMLRegistration;
import org.openide.awt.ActionID;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

public class HTMLViewProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(OpenHTMLRegistration.class.getCanonicalName());
        return hashSet;
    }

    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) throws LayerGenerationException {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(OpenHTMLRegistration.class)) {
            ActionID actionID;
            OpenHTMLRegistration openHTMLRegistration = element.getAnnotation(OpenHTMLRegistration.class);
            if (openHTMLRegistration == null || element.getKind() != ElementKind.METHOD) continue;
            if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("Method annotated by @OpenHTMLRegistration needs to be static", element);
            }
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.error("Method annotated by @OpenHTMLRegistration needs to be public", element);
            }
            if (!((ExecutableElement)element).getParameters().isEmpty()) {
                this.error("Method annotated by @OpenHTMLRegistration should have no arguments", element);
            }
            if (!element.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.error("Method annotated by @OpenHTMLRegistration needs to be public in a public class", element);
            }
            if ((actionID = element.getAnnotation(ActionID.class)) != null) {
                LayerBuilder layerBuilder = this.layer(new Element[]{element});
                LayerBuilder.File file = layerBuilder.file("Actions/" + actionID.category() + "/" + actionID.id().replace('.', '-') + ".instance").methodvalue("instanceCreate", "org.netbeans.modules.htmlui.Pages", "openAction");
                String string = LayerBuilder.absolutizeResource((Element)element, (String)openHTMLRegistration.url());
                try {
                    layerBuilder.validateResource(string, element, (Annotation)openHTMLRegistration, null, true);
                }
                catch (LayerGenerationException layerGenerationException) {
                    if (System.getProperty("netbeans.home") != null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Cannot find resource " + string, element);
                    }
                    throw layerGenerationException;
                }
                file.stringvalue("url", string);
                if (!openHTMLRegistration.iconBase().isEmpty()) {
                    file.stringvalue("iconBase", openHTMLRegistration.iconBase());
                }
                file.stringvalue("method", element.getSimpleName().toString());
                file.stringvalue("class", element.getEnclosingElement().asType().toString());
                String[] stringArray = openHTMLRegistration.techIds();
                for (int i = 0; i < stringArray.length; ++i) {
                    file.stringvalue("techId." + i, stringArray[i]);
                }
                file.bundlevalue("displayName", openHTMLRegistration.displayName(), (Annotation)openHTMLRegistration, "displayName");
                file.write();
                continue;
            }
            this.error("@OpenHTMLRegistration needs to be accompanied with @ActionID annotation", element);
        }
        return true;
    }

    private void error(String string, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string, element);
    }
}

