# ASUS P8Z77-M

This page describes how to run coreboot on the [ASUS P8Z77-M].

## Flashing coreboot

```{eval-rst}
+---------------------+----------------+
| Type                | Value          |
+=====================+================+
| Model               | W25Q64FVA1Q    |
+---------------------+----------------+
| Size                | 8 MiB          |
+---------------------+----------------+
| Package             | DIP-8          |
+---------------------+----------------+
| Socketed            | yes            |
+---------------------+----------------+
| Write protection    | yes            |
+---------------------+----------------+
| Dual BIOS feature   | no             |
+---------------------+----------------+
| Internal flashing   | yes            |
+---------------------+----------------+
```

The flash chip is located between the blue SATA ports.

The main SPI flash cannot be written internally because Asus disables BIOSWE and
enables ``BLE/SMM_BWP`` flags in ``BIOS_CNTL`` for their latest bioses.
To install coreboot for the first time, the flash chip must be removed and
flashed with an external programmer; flashing in-circuit doesn't work.
The flash chip is socketed, so it's easy to remove and reflash.

## Working

- All USB2 ports (mouse, keyboard and thumb drive)
- USB3 ports on rear (Boots Arch-based SystemRescue 6.0.3 off a Kingston DataTraveler G4 8GB)
- Gigabit Ethernet (RTL8111F)
- SATA3, SATA2 (all ports, hot-swap not tested)
- CPU Temp sensors and hardware monitor (See [Known issues] below)
- Native and MRC memory initialization
  (please see [RAM compatibility] below)

- Integrated graphics with both libgfxinit and the Intel Video BIOS OpROM
  (VGA/DVI-D/HDMI tested and working)
- 16x PCIe GPU in PCIe-16x/4x slots (tested using nVidia Quadro 600 under SystemRescue 6.0.3)
- Serial port
- PCI slot
  - Rockwell HSF 56k PCI modem (detected, not function tested)
  - Sound Blaster Live! CT4780 (detected, not function tested)
  - Promise SATA150 TX2plus (R/W OK to connected IDE hard drive, OpRom loaded, cannot boot from
  SeaBIOS)
- PCIe x1 slot
  - MSI Herald-BE (Qualcomm NCM865 m.2 Wifi 7 module via PCIe-m.2 adaptor)
- LPC POST card manually wired to TPM header
- 2-channel analog audio (WAV playback by mplayer via back panel line out port)
- HDMI digital audio
- Windows 10 with libgfxinit high resolution framebuffer and VBT
- UEFI boot into Fedora 38 through 41 with edk2 payload (202306 mrchromebox fork)
- PS/2 keyboard (IBM Model M #1391401 & original Microsoft Natural) with edk2 payload

## Known issues

- If you use MRC raminit, the NVRAM variable gfx_uma_size may be ignored as IGP's UMA could
  be reconfigured by the blob.

- Sometimes only half the memory is initialized, and/or at reduced speed. This is being
  investigated.

- If SeaBIOS is used for payload with libgfxinit, it must be brought in via coreboot's config.
  Otherwise integrated graphics would fail with a black screen.

- PCI POST card is not functional because the PCI bridge early init is not yet done.

- Although the black PCIEX16_2 slot can physically fit an x16 card, it only has physical
  contacts for x8, and is electrically x4 only.

- PS/2 keyboard may not work with SeaBIOS payload.

- These lm_sensors configurations are needed for hardware monitor values to make sense:

```bash
label in1 "+12V"
label in4 "+5V"
compute in1 @*12, @/12
compute in4 @*5, @/5
# ...
set temp1_type 4
set temp2_type 4

```

## Untested

- Wake-on-LAN
- USB3 on header
- TPM module
- EHCI debugging (Debug port is on the 5-pin side of USB2_910 header)
- S/PDIF audio out

## Not working

- PS/2 mouse (a patch has been submitted for review)
- 4 and 6 channel analog audio out: Rear left and right audio is a muted
  copy of front left and right audio, and the other two channels are silent.

## RAM compatibility

### Native and MRC raminit:

- OCZ OCZ3G1600LVAM 2x2GB kit works at DDR3-1066 instead of DDR3-1600.
- Samsung PC3-10600U 2x2GB kit works at full rated speed.
- GSkill F3-1600C9D-16GRSL 2x8GB SODIMM kit on unbranded adapter works at full rated speed.

### MRC raminit:

- Corsair ValueSelect CMSO4GX3M1C1600C11 4GB SODIMM works at full rated speed
  on an unbranded adapter.
- Samsung M471B5273DH0 4GB SODIMM on adapter works at full rated speed.

### Native raminit:

- Kingston KTH9600B-4G 2x4GB kit works at full rated speed.
- Samsung M471B5273DH0 4GB SODIMM on adapter works only at DDR3-1066 if max_mem_clock_mhz
  is reduced to 666, and only one module would be detected. It will completely fail to
  train if max_mem_clock_mhz is set to 800.
- Corsair modules on channel 1 fails training and is unusable.
- Two Patriot PV316G160C9K 2x8GB kits in all slots work at full rated speed.

## Extra onboard buttons

The board has two onboard buttons, each with a related LED nearby.

- `BIOS_FLBK` / `FLBK_LED`:
  OEM firmware uses this button to facilitate a simple update mechanism
  via a USB drive plugged into the bottom USB port of the USB/LAN stack.
  They are connected to a proprietary AI1314 microcontroller.
  They currently do nothing under coreboot.

- `MemOK!` / `DRAM_LED`:
  OEM firmware uses this button for memory tuning related to overclocking.
  They are connected to the NCT6779D super I/O chip.
  Button is connected to pin 74, and currently do nothing under coreboot.
  DRAM_LED is connected to GP07 pin. Active low. Since commit f7ed007298e0
  coreboot lights it up during early boot similar to vendor firmware.

## Technology

```{eval-rst}
+------------------+--------------------------------------------------+
| Northbridge      | :doc:`../../northbridge/intel/sandybridge/index` |
+------------------+--------------------------------------------------+
| Southbridge      | bd82x6x                                          |
+------------------+--------------------------------------------------+
| CPU              | model_206ax                                      |
+------------------+--------------------------------------------------+
| Super I/O        | Nuvoton NCT6779D                                 |
+------------------+--------------------------------------------------+
| EC               | None                                             |
+------------------+--------------------------------------------------+
| Coprocessor      | Intel Management Engine                          |
+------------------+--------------------------------------------------+
```

## Extra resources

- [Flash chip datasheet][W25Q64FVA1Q]

[ASUS P8Z77-M]: https://www.asus.com/supportonly/p8z77-m/helpdesk_manual/
[W25Q64FVA1Q]: https://www.winbond.com/resource-files/w25q64fv%20revs%2007182017.pdf
[flashrom]: https://flashrom.org/
