import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["sdkKey", "environment", "updateUserCompletionCallback", "perimeter"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import _regeneratorRuntime from "@babel/runtime/regenerator";
import { _makeLayer, StatsigClient } from '@statsig/js-client';
import Subscriptions from '../subscriptions';
import { DynamicConfig } from './compat/DynamicConfig';
import { Layer } from './compat/Layer';
import { EvaluationReason } from './compat/types';
import Fetcher from './fetcher';
import { NoFetchDataAdapter } from './NoFetchDataAdapter';
import { LOCAL_STORAGE_KEY, PersistentOverrideAdapter } from './PersistentOverrideAdapter';
import { FeatureGateEnvironment, PerimeterType } from './types';
import { getOptionsWithDefaults, migrateInitializationOptions, shallowEquals, toStatsigUser } from './utils';
import { CLIENT_VERSION } from './version';
var DEFAULT_CLIENT_KEY = 'client-default-key';
// default event logging api is Atlassian proxy rather than Statsig's domain, to avoid ad blockers
var DEFAULT_EVENT_LOGGING_API = 'https://xp.atlassian.com/v1/rgstr';
export var Client = /*#__PURE__*/function () {
  function Client() {
    var _this = this;
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      _ref$localStorageKey = _ref.localStorageKey,
      localStorageKey = _ref$localStorageKey === void 0 ? LOCAL_STORAGE_KEY : _ref$localStorageKey;
    _classCallCheck(this, Client);
    _defineProperty(this, "initPromise", null);
    /** True if an initialize method was called and completed successfully. */
    _defineProperty(this, "initCompleted", false);
    /**
     * True if an initialize method was called and completed, meaning the client is now usable.
     * However if there was an error during initialization it may have initialized with default
     * values. Use {@link initCompleted} to check for this.
     */
    _defineProperty(this, "initWithDefaults", false);
    _defineProperty(this, "hasCheckGateErrorOccurred", false);
    _defineProperty(this, "hasGetExperimentErrorOccurred", false);
    _defineProperty(this, "hasGetExperimentValueErrorOccurred", false);
    _defineProperty(this, "hasGetLayerErrorOccurred", false);
    _defineProperty(this, "hasGetLayerValueErrorOccurred", false);
    _defineProperty(this, "subscriptions", new Subscriptions());
    _defineProperty(this, "dataAdapter", new NoFetchDataAdapter());
    /**
     * Call this if modifying the values being served by the Statsig library since it has its own
     * memoization cache which will not be updated if the values are changed outside of the library.
     */
    _defineProperty(this, "statsigValuesUpdated", function () {
      if (_this.user) {
        // Trigger a reset of the memoize cache
        _this.statsigClient.updateUserSync(_this.user, {
          disableBackgroundCacheRefresh: true
        });
      }
      _this.subscriptions.anyUpdated();
    });
    this.overrideAdapter = new PersistentOverrideAdapter(localStorageKey);
  }

  /**
   * @description
   * This method initializes the client using a network call to fetch the bootstrap values.
   * If the client is inialized with an `analyticsWebClient`, it will send an operational event
   * to GASv3 with the following attributes:
   * - targetApp: the target app of the client
   * - clientVersion: the version of the client
   * - success: whether the initialization was successful
   * - startTime: the time when the initialization started
   * - totalTime: the total time it took to initialize the client
   * - apiKey: the api key used to initialize the client
   * @param clientOptions {ClientOptions}
   * @param identifiers {Identifiers}
   * @param customAttributes {CustomAttributes}
   * @returns {Promise<void>}
   */
  return _createClass(Client, [{
    key: "initialize",
    value: (function () {
      var _initialize = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(clientOptions, identifiers, customAttributes) {
        var _this2 = this;
        var clientOptionsWithDefaults, startTime;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              clientOptionsWithDefaults = getOptionsWithDefaults(clientOptions);
              if (!this.initPromise) {
                _context.next = 4;
                break;
              }
              if (!shallowEquals(clientOptionsWithDefaults, this.initOptions)) {
                // eslint-disable-next-line no-console
                console.warn('Feature Gates client already initialized with different options. New options were not applied.');
              }
              return _context.abrupt("return", this.initPromise);
            case 4:
              startTime = performance.now();
              this.initOptions = clientOptionsWithDefaults;
              this.initPromise = this.init(clientOptionsWithDefaults, identifiers, customAttributes).then(function () {
                _this2.initCompleted = true;
                _this2.initWithDefaults = true;
              }).finally(function () {
                var endTime = performance.now();
                var totalTime = endTime - startTime;
                _this2.fireClientEvent(startTime, totalTime, 'initialize', _this2.initCompleted, clientOptionsWithDefaults.apiKey);
              });
              return _context.abrupt("return", this.initPromise);
            case 8:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function initialize(_x, _x2, _x3) {
        return _initialize.apply(this, arguments);
      }
      return initialize;
    }()
    /**
     * @description
     * This method initializes the client using the provider given to call to fetch the bootstrap values.
     * If the client is initialized with an `analyticsWebClient`, it will send an operational event
     * to GASv3 with the following attributes:
     * - targetApp: the target app of the client
     * - clientVersion: the version of the client
     * - success: whether the initialization was successful
     * - startTime: the time when the initialization started
     * - totalTime: the total time it took to initialize the client
     * - apiKey: the api key used to initialize the client
     * @param clientOptions {ClientOptions}
     * @param provider {Provider}
     * @param identifiers {Identifiers}
     * @param customAttributes {CustomAttributes}
     * @returns {Promise<void>}
     */
    )
  }, {
    key: "initializeWithProvider",
    value: (function () {
      var _initializeWithProvider = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(clientOptions, provider, identifiers, customAttributes) {
        var _this3 = this;
        var clientOptionsWithDefaults, startTime;
        return _regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              clientOptionsWithDefaults = getOptionsWithDefaults(clientOptions);
              if (!this.initPromise) {
                _context2.next = 4;
                break;
              }
              if (!shallowEquals(clientOptionsWithDefaults, this.initOptions)) {
                // eslint-disable-next-line no-console
                console.warn('Feature Gates client already initialized with different options. New options were not applied.');
              }
              return _context2.abrupt("return", this.initPromise);
            case 4:
              startTime = performance.now();
              this.initOptions = clientOptionsWithDefaults;
              this.provider = provider;
              this.provider.setClientVersion(CLIENT_VERSION);
              if (this.provider.setApplyUpdateCallback) {
                this.provider.setApplyUpdateCallback(this.applyUpdateCallback.bind(this));
              }
              this.initPromise = this.initWithProvider(clientOptionsWithDefaults, provider, identifiers, customAttributes).then(function () {
                _this3.initCompleted = true;
                _this3.initWithDefaults = true;
              }).finally(function () {
                var endTime = performance.now();
                var totalTime = endTime - startTime;
                _this3.fireClientEvent(startTime, totalTime, 'initializeWithProvider', _this3.initCompleted, provider.getApiKey ? provider.getApiKey() : undefined);
              });
              return _context2.abrupt("return", this.initPromise);
            case 11:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function initializeWithProvider(_x4, _x5, _x6, _x7) {
        return _initializeWithProvider.apply(this, arguments);
      }
      return initializeWithProvider;
    }())
  }, {
    key: "applyUpdateCallback",
    value: function applyUpdateCallback(experimentsResult) {
      try {
        if (this.initCompleted || this.initWithDefaults) {
          this.assertInitialized(this.statsigClient);
          this.dataAdapter.setBootstrapData(experimentsResult.experimentValues);
          this.dataAdapter.setData(JSON.stringify(experimentsResult.experimentValues));
          this.statsigValuesUpdated();
        }
      } catch (error) {
        // eslint-disable-next-line no-console
        console.warn('Error when attempting to apply update', error);
      }
    }
  }, {
    key: "fireClientEvent",
    value: function fireClientEvent(startTime, totalTime, action, success) {
      var _analyticsWebClient,
        _this4 = this;
      var apiKey = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : undefined;
      (_analyticsWebClient = this.initOptions.analyticsWebClient) === null || _analyticsWebClient === void 0 || _analyticsWebClient.then(function (analyticsWebClient) {
        var attributes = _objectSpread({
          targetApp: _this4.initOptions.targetApp,
          clientVersion: CLIENT_VERSION,
          success: success,
          startTime: startTime,
          totalTime: totalTime
        }, apiKey && {
          apiKey: apiKey
        });
        analyticsWebClient.sendOperationalEvent({
          action: action,
          actionSubject: 'featureGatesClient',
          attributes: attributes,
          tags: ['measurement'],
          source: '@atlaskit/feature-gate-js-client'
        });
      }).catch(function (err) {
        if (_this4.initOptions.environment !== FeatureGateEnvironment.Production) {
          // eslint-disable-next-line no-console
          console.error('Analytics web client promise did not resolve', err);
        }
      });
    }
  }, {
    key: "initializeFromValues",
    value: function () {
      var _initializeFromValues = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(clientOptions, identifiers, customAttributes) {
        var _this5 = this;
        var initializeValues,
          clientOptionsWithDefaults,
          startTime,
          _args3 = arguments;
        return _regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              initializeValues = _args3.length > 3 && _args3[3] !== undefined ? _args3[3] : {};
              clientOptionsWithDefaults = getOptionsWithDefaults(clientOptions);
              if (!this.initPromise) {
                _context3.next = 5;
                break;
              }
              if (!shallowEquals(clientOptionsWithDefaults, this.initOptions)) {
                // eslint-disable-next-line no-console
                console.warn('Feature Gates client already initialized with different options. New options were not applied.');
              }
              return _context3.abrupt("return", this.initPromise);
            case 5:
              // This makes sure the new Statsig client behaves like the old when bootstrap data is
              // passed, and `has_updates` isn't specified (which happens a lot in product integration tests).
              if (!Object.prototype.hasOwnProperty.call(initializeValues, 'has_updates')) {
                initializeValues['has_updates'] = true;
              }
              startTime = performance.now();
              this.initOptions = clientOptionsWithDefaults;
              this.initPromise = this.initFromValues(clientOptionsWithDefaults, identifiers, customAttributes, initializeValues).then(function () {
                _this5.initCompleted = true;
                _this5.initWithDefaults = true;
              }).finally(function () {
                var endTime = performance.now();
                var totalTime = endTime - startTime;
                _this5.fireClientEvent(startTime, totalTime, 'initializeFromValues', _this5.initCompleted);
              });
              return _context3.abrupt("return", this.initPromise);
            case 10:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function initializeFromValues(_x8, _x9, _x10) {
        return _initializeFromValues.apply(this, arguments);
      }
      return initializeFromValues;
    }()
  }, {
    key: "assertInitialized",
    value: function assertInitialized(statsigClient) {
      if (!statsigClient) {
        throw new Error('Client must be initialized before using this method');
      }
    }

    /**
     * This method updates the user using a network call to fetch the new set of values.
     * @param fetchOptions {FetcherOptions}
     * @param identifiers {Identifiers}
     * @param customAttributes {CustomAttributes}
     */
  }, {
    key: "updateUser",
    value: (function () {
      var _updateUser = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(fetchOptions, identifiers, customAttributes) {
        var fetchOptionsWithDefaults, initializeValuesProducer;
        return _regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              this.assertInitialized(this.statsigClient);
              fetchOptionsWithDefaults = getOptionsWithDefaults(fetchOptions);
              initializeValuesProducer = function initializeValuesProducer() {
                return Fetcher.fetchExperimentValues(fetchOptionsWithDefaults, identifiers, customAttributes).then(function (_ref2) {
                  var experimentValues = _ref2.experimentValues,
                    customAttributes = _ref2.customAttributes;
                  return {
                    experimentValues: experimentValues,
                    customAttributesFromFetch: customAttributes
                  };
                });
              };
              _context4.next = 5;
              return this.updateUserUsingInitializeValuesProducer(initializeValuesProducer, identifiers, customAttributes);
            case 5:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function updateUser(_x11, _x12, _x13) {
        return _updateUser.apply(this, arguments);
      }
      return updateUser;
    }()
    /**
     * This method updates the user using the provider given on initialisation to get the new set of
     * values.
     * @param identifiers {Identifiers}
     * @param customAttributes {CustomAttributes}
     */
    )
  }, {
    key: "updateUserWithProvider",
    value: (function () {
      var _updateUserWithProvider = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(identifiers, customAttributes) {
        var _this6 = this;
        return _regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              this.assertInitialized(this.statsigClient);
              if (this.provider) {
                _context5.next = 3;
                break;
              }
              throw new Error('Cannot update user using provider as the client was not initialised with a provider');
            case 3:
              _context5.next = 5;
              return this.provider.setProfile(this.initOptions, identifiers, customAttributes);
            case 5:
              _context5.next = 7;
              return this.updateUserUsingInitializeValuesProducer(function () {
                return _this6.provider.getExperimentValues();
              }, identifiers, customAttributes);
            case 7:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this);
      }));
      function updateUserWithProvider(_x14, _x15) {
        return _updateUserWithProvider.apply(this, arguments);
      }
      return updateUserWithProvider;
    }()
    /**
     * This method updates the user given a new set of bootstrap values obtained from one of the
     * server-side SDKs.
     *
     * @param identifiers {Identifiers}
     * @param customAttributes {CustomAttributes}
     * @param initializeValues {Record<string,unknown>}
     */
    )
  }, {
    key: "updateUserWithValues",
    value: (function () {
      var _updateUserWithValues = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(identifiers, customAttributes) {
        var initializeValues,
          initializeValuesProducer,
          _args6 = arguments;
        return _regeneratorRuntime.wrap(function _callee6$(_context6) {
          while (1) switch (_context6.prev = _context6.next) {
            case 0:
              initializeValues = _args6.length > 2 && _args6[2] !== undefined ? _args6[2] : {};
              this.assertInitialized(this.statsigClient);
              initializeValuesProducer = function initializeValuesProducer() {
                return Promise.resolve({
                  experimentValues: initializeValues,
                  customAttributesFromFetch: customAttributes
                });
              };
              _context6.next = 5;
              return this.updateUserUsingInitializeValuesProducer(initializeValuesProducer, identifiers, customAttributes);
            case 5:
            case "end":
              return _context6.stop();
          }
        }, _callee6, this);
      }));
      function updateUserWithValues(_x16, _x17) {
        return _updateUserWithValues.apply(this, arguments);
      }
      return updateUserWithValues;
    }())
  }, {
    key: "initializeCalled",
    value: function initializeCalled() {
      return this.initPromise != null;
    }
  }, {
    key: "initializeCompleted",
    value: function initializeCompleted() {
      return this.initCompleted;
    }

    /**
     * Returns the value for a feature gate. Returns false if there are errors.
     * @param {string} gateName - The name of the feature gate.
     * @param {Object} options
     * @param {boolean} options.fireGateExposure
     *        Whether or not to fire the exposure event for the gate. Defaults to true.
     *        To log an exposure event manually at a later time, use {@link Client.manuallyLogGateExposure}
     *        (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
     */
  }, {
    key: "checkGate",
    value: function checkGate(gateName) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      try {
        this.assertInitialized(this.statsigClient);
        var _options$fireGateExpo = options.fireGateExposure,
          fireGateExposure = _options$fireGateExpo === void 0 ? true : _options$fireGateExpo;
        return this.statsigClient.checkGate(gateName, {
          disableExposureLog: !fireGateExposure
        });
      } catch (error) {
        // Log the first occurrence of the error
        if (!this.hasCheckGateErrorOccurred) {
          // eslint-disable-next-line no-console
          console.warn({
            msg: 'An error has occurred checking the feature gate. Only the first occurrence of this error is logged.',
            gateName: gateName,
            error: error
          });
          this.hasCheckGateErrorOccurred = true;
        }
        return false;
      }
    }
  }, {
    key: "isGateExist",
    value: function isGateExist(gateName) {
      try {
        this.assertInitialized(this.statsigClient);
        var gate = this.statsigClient.getFeatureGate(gateName, {
          disableExposureLog: true
        });
        return !gate.details.reason.includes('Unrecognized');
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error("Error occurred when trying to check FeatureGate: ".concat(error));
        // in case of error report true to avoid false positives.
        return true;
      }
    }
  }, {
    key: "isExperimentExist",
    value: function isExperimentExist(experimentName) {
      try {
        this.assertInitialized(this.statsigClient);
        var config = this.statsigClient.getExperiment(experimentName, {
          disableExposureLog: true
        });
        return !config.details.reason.includes('Unrecognized');
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error("Error occurred when trying to check Experiment: ".concat(error));
        // in case of error report true to avoid false positives.
        return true;
      }
    }

    /**
     * Manually log a gate exposure (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
     * This is useful if you have evaluated a gate earlier via {@link Client.checkGate} where
     * <code>options.fireGateExposure</code> is false.
     * @param gateName
     */
  }, {
    key: "manuallyLogGateExposure",
    value: function manuallyLogGateExposure(gateName) {
      this.assertInitialized(this.statsigClient);
      // This is the approach recommended in the docs
      // https://docs.statsig.com/client/javascript-sdk/#manual-exposures-
      this.statsigClient.checkGate(gateName);
    }

    /**
     * Returns the entire config for a given experiment.
     *
     * @param {string} experimentName - The name of the experiment
     * @param {Object} options
     * @param {boolean} options.fireExperimentExposure - Whether or not to fire the exposure event
     * for the experiment. Defaults to true. To log an exposure event manually at a later time, use
     * {@link Client.manuallyLogExperimentExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
     * @returns The config for an experiment
     * @example
     * ```ts
     * const experimentConfig = client.getExperiment('example-experiment-name');
     * const backgroundColor: string = experimentConfig.get('backgroundColor', 'yellow');
     * ```
     */
  }, {
    key: "getExperiment",
    value: function getExperiment(experimentName) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      try {
        this.assertInitialized(this.statsigClient);
        var _options$fireExperime = options.fireExperimentExposure,
          fireExperimentExposure = _options$fireExperime === void 0 ? true : _options$fireExperime;
        return DynamicConfig.fromExperiment(this.statsigClient.getExperiment(experimentName, {
          disableExposureLog: !fireExperimentExposure
        }));
      } catch (error) {
        // Log the first occurrence of the error
        if (!this.hasGetExperimentErrorOccurred) {
          // eslint-disable-next-line no-console
          console.warn({
            msg: 'An error has occurred getting the experiment. Only the first occurrence of this error is logged.',
            experimentName: experimentName,
            error: error
          });
          this.hasGetExperimentErrorOccurred = true;
        }

        // Return a default value
        return new DynamicConfig(experimentName, {}, '', {
          time: Date.now(),
          reason: EvaluationReason.Error
        });
      }
    }

    /**
     * Returns the value of a given parameter in an experiment config.
     *
     * @template T
     * @param {string} experimentName - The name of the experiment
     * @param {string} parameterName - The name of the parameter to fetch from the experiment config
     * @param {T} defaultValue - The value to serve if the experiment or parameter do not exist, or
     * if the returned value does not match the expected type.
     * @param {Object} options
     * @param {boolean} options.fireExperimentExposure - Whether or not to fire the exposure event
     * for the experiment. Defaults to true. To log an exposure event manually at a later time, use
     * {@link Client.manuallyLogExperimentExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-))
     * @param {function} options.typeGuard - A function that asserts that the return value has the
     * expected type. If this function returns false, then the default value will be returned
     * instead. This can be set to protect your code from unexpected values being set remotely. By
     * default, this will be done by asserting that the default value and value are the same primitive
     * type.
     * @returns The value of the parameter if the experiment and parameter both exist, otherwise the
     * default value.
     * @example
     ``` ts
     type ValidColor = 'blue' | 'red' | 'yellow';
     type ValidColorTypeCheck = (value: unknown) => value is ValidColor;
    	 const isValidColor: ValidColorTypeCheck =
    		(value: unknown) => typeof value === 'string' && ['blue', 'red', 'yellow'].includes(value);
    	 const buttonColor: ValidColor = client.getExperimentValue(
    		'example-experiment-name',
    		'backgroundColor',
    		'yellow',
    		{
    				typeGuard: isValidColor
    		}
     );
     ```
    */
  }, {
    key: "getExperimentValue",
    value: function getExperimentValue(experimentName, parameterName, defaultValue) {
      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var experiment = this.getExperiment(experimentName, options);
      try {
        var typeGuard = options.typeGuard;
        return experiment.get(parameterName, defaultValue, typeGuard);
      } catch (error) {
        // Log the first occurrence of the error
        if (!this.hasGetExperimentValueErrorOccurred) {
          // eslint-disable-next-line no-console
          console.warn({
            msg: 'An error has occurred getting the experiment value. Only the first occurrence of this error is logged.',
            experimentName: experimentName,
            defaultValue: defaultValue,
            options: options,
            error: error
          });
          this.hasGetExperimentValueErrorOccurred = true;
        }
        return defaultValue;
      }
    }

    /**
     * Manually log an experiment exposure (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
     * This is useful if you have evaluated an experiment earlier via {@link Client.getExperimentValue} or
     * {@link Client.getExperiment} where <code>options.fireExperimentExposure</code> is false.
     * @param experimentName
     */
  }, {
    key: "manuallyLogExperimentExposure",
    value: function manuallyLogExperimentExposure(experimentName) {
      this.assertInitialized(this.statsigClient);
      // This is the approach recommended in the docs
      // https://docs.statsig.com/client/javascript-sdk/#manual-exposures-
      this.statsigClient.getExperiment(experimentName);
    }

    /**
     * Manually log a layer exposure (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
     * This is useful if you have evaluated a layer earlier via {@link Client.getLayerValue} where <code>options.fireExperimentExposure</code> is false.
     * @param layerName
     * @param parameterName
     */
  }, {
    key: "manuallyLogLayerExposure",
    value: function manuallyLogLayerExposure(layerName, parameterName) {
      var _this$statsigClient$g;
      this.assertInitialized(this.statsigClient);
      // This is the approach recommended in the docs
      // https://docs.statsig.com/client/javascript-sdk/#manual-exposures-
      (_this$statsigClient$g = this.statsigClient.getLayer(layerName)) === null || _this$statsigClient$g === void 0 || _this$statsigClient$g.get(parameterName);
    }
  }, {
    key: "shutdownStatsig",
    value: function shutdownStatsig() {
      this.assertInitialized(this.statsigClient);
      this.statsigClient.shutdown();
    }

    /**
     * Adds a new override for the given gate.
     *
     * This method is additive, meaning you can call it multiple times with different gate names to
     * build your full set of overrides.
     *
     * Overrides are persisted to the `STATSIG_OVERRIDES` key in localStorage, so they
     * will continue to affect every client that is initialized on the same domain after this method
     * is called. If you are using this API for testing purposes, you should call
     * {@link Client.clearGateOverride} after your tests are completed to remove this
     * localStorage entry.
     *
     * @param {string} gateName
     * @param {boolean} value
     */
  }, {
    key: "overrideGate",
    value: function overrideGate(gateName, value) {
      this.overrideAdapter.overrideGate(gateName, value);
      // Trigger a reset of the memoized gate value
      if (this.user) {
        var _this$statsigClient;
        (_this$statsigClient = this.statsigClient) === null || _this$statsigClient === void 0 || _this$statsigClient.updateUserSync(this.user, {
          disableBackgroundCacheRefresh: true
        });
      }
      this.statsigValuesUpdated();
    }

    /**
     * Removes any overrides that have been set for the given gate.
     */
  }, {
    key: "clearGateOverride",
    value: function clearGateOverride(gateName) {
      this.overrideAdapter.removeGateOverride(gateName);
      this.statsigValuesUpdated();
    }

    /**
     * Adds a new override for the given config (or experiment).
     *
     * This method is additive, meaning you can call it multiple times with different experiment
     * names to build your full set of overrides.
     *
     * Overrides are persisted to the `STATSIG_OVERRIDES` key in localStorage, so they
     * will continue to affect every client that is initialized on the same domain after this method
     * is called. If you are using this API for testing purposes, you should call
     * {@link Client.clearConfigOverride} after your tests are completed to remove this
     * localStorage entry.
     *
     * @param {string} experimentName
     * @param {object} values
     */
  }, {
    key: "overrideConfig",
    value: function overrideConfig(experimentName, values) {
      this.overrideAdapter.overrideDynamicConfig(experimentName, values);
      this.statsigValuesUpdated();
    }

    /**
     * Removes any overrides that have been set for the given experiment.
     * @param {string} experimentName
     */
  }, {
    key: "clearConfigOverride",
    value: function clearConfigOverride(experimentName) {
      this.overrideAdapter.removeDynamicConfigOverride(experimentName);
      this.statsigValuesUpdated();
    }

    /**
     * Set overrides for gates, experiments and layers in batch.
     *
     * Note that these overrides are **not** additive and will completely replace any that have been
     * added via prior calls to {@link Client.overrideConfig} or
     * {@link Client.overrideGate}.
     *
     * Overrides are persisted to the `STATSIG_OVERRIDES` key in localStorage, so they
     * will continue to affect every client that is initialized on the same domain after this method
     * is called. If you are using this API for testing purposes, you should call
     * {@link Client.clearAllOverrides} after your tests are completed to remove this
     * localStorage entry.
     */
  }, {
    key: "setOverrides",
    value: function setOverrides(overrides) {
      this.overrideAdapter.setOverrides(overrides);
      this.statsigValuesUpdated();
    }

    /**
     * @returns The current overrides for gates, configs (including experiments) and layers.
     */
  }, {
    key: "getOverrides",
    value: function getOverrides() {
      return this.overrideAdapter.getOverrides();
    }

    /**
     * Clears overrides for all gates, configs (including experiments) and layers.
     */
  }, {
    key: "clearAllOverrides",
    value: function clearAllOverrides() {
      this.overrideAdapter.removeAllOverrides();
      this.statsigValuesUpdated();
    }

    /**
     * Returns whether the given identifiers and customAttributes align with the current
     * set that is being used by the client.
     *
     * If this method returns false, then the {@link Client.updateUser},
     * {@link Client.updateUserWithValues} or {@link Client.updateUserWithProvider}
     * methods can be used to re-align these values.
     *
     * @param identifiers
     * @param customAttributes
     * @returns a flag indicating whether the clients current configuration aligns with the given values
     */
  }, {
    key: "isCurrentUser",
    value: function isCurrentUser(identifiers, customAttributes) {
      return shallowEquals(this.currentIdentifiers, identifiers) && shallowEquals(this.currentAttributes, customAttributes);
    }

    /**
     * Subscribe to updates where the given callback will be called with the current checkGate value
     * @param gateName
     * @param callback
     * @param options
     * @returns off function to unsubscribe from updates
     */
  }, {
    key: "onGateUpdated",
    value: function onGateUpdated(gateName, callback) {
      var _this7 = this;
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      var wrapCallback = function wrapCallback(value) {
        var _options$fireGateExpo2 = options.fireGateExposure,
          fireGateExposure = _options$fireGateExpo2 === void 0 ? true : _options$fireGateExpo2;
        if (fireGateExposure) {
          _this7.manuallyLogGateExposure(gateName);
        }
        try {
          callback(value);
        } catch (error) {
          // eslint-disable-next-line no-console
          console.warn("Error calling callback for gate ".concat(gateName, " with value ").concat(value), error);
        }
      };
      return this.subscriptions.onGateUpdated(gateName, wrapCallback, this.checkGate.bind(this), options);
    }

    /**
     * Subscribe to updates where the given callback will be called with the current experiment value
     * @param experimentName
     * @param parameterName
     * @param defaultValue
     * @param callback
     * @param options
     * @returns off function to unsubscribe from updates
     */
  }, {
    key: "onExperimentValueUpdated",
    value: function onExperimentValueUpdated(experimentName, parameterName, defaultValue, callback) {
      var _this8 = this;
      var options = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};
      var wrapCallback = function wrapCallback(value) {
        var _options$fireExperime2 = options.fireExperimentExposure,
          fireExperimentExposure = _options$fireExperime2 === void 0 ? true : _options$fireExperime2;
        if (fireExperimentExposure) {
          _this8.manuallyLogExperimentExposure(experimentName);
        }
        try {
          callback(value);
        } catch (error) {
          // eslint-disable-next-line no-console
          console.warn("Error calling callback for experiment ".concat(experimentName, " with value ").concat(value), error);
        }
      };
      return this.subscriptions.onExperimentValueUpdated(experimentName, parameterName, defaultValue, wrapCallback, this.getExperimentValue.bind(this), options);
    }

    /**
     * Subscribe so on any update the callback will be called.
     * NOTE: The callback will be called whenever the values are updated even if the values have not
     * changed.
     * @param callback
     * @returns off function to unsubscribe from updates
     */
  }, {
    key: "onAnyUpdated",
    value: function onAnyUpdated(callback) {
      return this.subscriptions.onAnyUpdated(callback);
    }

    /**
     * This method initializes the client using a network call to fetch the bootstrap values for the
     * given user.
     *
     * @param clientOptions
     * @param identifiers
     * @param customAttributes
     * @private
     */
  }, {
    key: "init",
    value: (function () {
      var _init = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(clientOptions, identifiers, customAttributes) {
        var fromValuesClientOptions, experimentValues, customAttributesFromResult, clientSdkKeyPromise, experimentValuesPromise, _yield$Promise$all, _yield$Promise$all2, experimentValuesResult;
        return _regeneratorRuntime.wrap(function _callee7$(_context7) {
          while (1) switch (_context7.prev = _context7.next) {
            case 0:
              fromValuesClientOptions = _objectSpread({}, clientOptions);
              _context7.prev = 1;
              // If client sdk key fetch fails, an error would be thrown and handled instead of waiting for
              // the experiment values request to be settled, and it will fall back to use default values.
              clientSdkKeyPromise = Fetcher.fetchClientSdk(clientOptions).then(function (value) {
                return fromValuesClientOptions.sdkKey = value.clientSdkKey;
              });
              experimentValuesPromise = Fetcher.fetchExperimentValues(clientOptions, identifiers, customAttributes); // Only wait for the experiment values request to finish and try to initialise the client
              // with experiment values if both requests are successful. Else an error would be thrown and
              // handled by the catch
              _context7.next = 6;
              return Promise.all([clientSdkKeyPromise, experimentValuesPromise]);
            case 6:
              _yield$Promise$all = _context7.sent;
              _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 2);
              experimentValuesResult = _yield$Promise$all2[1];
              experimentValues = experimentValuesResult.experimentValues;
              customAttributesFromResult = experimentValuesResult.customAttributes;
              _context7.next = 20;
              break;
            case 13:
              _context7.prev = 13;
              _context7.t0 = _context7["catch"](1);
              if (_context7.t0 instanceof Error) {
                // eslint-disable-next-line no-console
                console.error("Error occurred when trying to fetch the Feature Gates client values, error: ".concat(_context7.t0 === null || _context7.t0 === void 0 ? void 0 : _context7.t0.message));
              }
              // eslint-disable-next-line no-console
              console.warn("Initialising Statsig client without values");
              _context7.next = 19;
              return this.initFromValues(fromValuesClientOptions, identifiers, customAttributes);
            case 19:
              throw _context7.t0;
            case 20:
              return _context7.abrupt("return", this.initFromValues(fromValuesClientOptions, identifiers, customAttributesFromResult, experimentValues));
            case 21:
            case "end":
              return _context7.stop();
          }
        }, _callee7, this, [[1, 13]]);
      }));
      function init(_x18, _x19, _x20) {
        return _init.apply(this, arguments);
      }
      return init;
    }())
  }, {
    key: "initWithProvider",
    value: function () {
      var _initWithProvider = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee8(baseClientOptions, provider, identifiers, customAttributes) {
        var fromValuesClientOptions, experimentValues, customAttributesFromResult, clientSdkKeyPromise, experimentValuesPromise, _yield$Promise$all3, _yield$Promise$all4, experimentValuesResult;
        return _regeneratorRuntime.wrap(function _callee8$(_context8) {
          while (1) switch (_context8.prev = _context8.next) {
            case 0:
              fromValuesClientOptions = _objectSpread(_objectSpread({}, baseClientOptions), {}, {
                disableCurrentPageLogging: true
              });
              _context8.prev = 1;
              _context8.next = 4;
              return provider.setProfile(baseClientOptions, identifiers, customAttributes);
            case 4:
              // If client sdk key fetch fails, an error would be thrown and handled instead of waiting for
              // the experiment values request to be settled, and it will fall back to use default values.
              clientSdkKeyPromise = provider.getClientSdkKey().then(function (value) {
                return fromValuesClientOptions.sdkKey = value;
              });
              experimentValuesPromise = provider.getExperimentValues(); // Only wait for the experiment values request to finish and try to initialise the client
              // with experiment values if both requests are successful. Else an error would be thrown and
              // handled by the catch
              _context8.next = 8;
              return Promise.all([clientSdkKeyPromise, experimentValuesPromise]);
            case 8:
              _yield$Promise$all3 = _context8.sent;
              _yield$Promise$all4 = _slicedToArray(_yield$Promise$all3, 2);
              experimentValuesResult = _yield$Promise$all4[1];
              experimentValues = experimentValuesResult.experimentValues;
              customAttributesFromResult = experimentValuesResult.customAttributesFromFetch;
              _context8.next = 22;
              break;
            case 15:
              _context8.prev = 15;
              _context8.t0 = _context8["catch"](1);
              if (_context8.t0 instanceof Error) {
                // eslint-disable-next-line no-console
                console.error("Error occurred when trying to fetch the Feature Gates client values, error: ".concat(_context8.t0 === null || _context8.t0 === void 0 ? void 0 : _context8.t0.message));
              }
              // eslint-disable-next-line no-console
              console.warn("Initialising Statsig client without values");
              _context8.next = 21;
              return this.initFromValues(fromValuesClientOptions, identifiers, customAttributes);
            case 21:
              throw _context8.t0;
            case 22:
              return _context8.abrupt("return", this.initFromValues(fromValuesClientOptions, identifiers, customAttributesFromResult, experimentValues));
            case 23:
            case "end":
              return _context8.stop();
          }
        }, _callee8, this, [[1, 15]]);
      }));
      function initWithProvider(_x21, _x22, _x23, _x24) {
        return _initWithProvider.apply(this, arguments);
      }
      return initWithProvider;
    }()
    /**
     * This method initializes the client using a set of boostrap values obtained from one of the
     * server-side SDKs.
     *
     * @param clientOptions
     * @param identifiers
     * @param customAttributes
     * @param initializeValues
     * @private
     */
  }, {
    key: "initFromValues",
    value: (function () {
      var _initFromValues = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee9(clientOptions, identifiers, customAttributes) {
        var _newClientOptions$net;
        var initializeValues,
          newClientOptions,
          sdkKey,
          environment,
          _updateUserCompletionCallback,
          _perimeter,
          restClientOptions,
          statsigOptions,
          _args9 = arguments;
        return _regeneratorRuntime.wrap(function _callee9$(_context9) {
          while (1) switch (_context9.prev = _context9.next) {
            case 0:
              initializeValues = _args9.length > 3 && _args9[3] !== undefined ? _args9[3] : {};
              this.overrideAdapter.initFromStoredOverrides();
              this.currentIdentifiers = identifiers;
              this.currentAttributes = customAttributes;
              newClientOptions = migrateInitializationOptions(clientOptions);
              if (!newClientOptions.sdkKey) {
                newClientOptions.sdkKey = DEFAULT_CLIENT_KEY;
              }
              if (!((_newClientOptions$net = newClientOptions.networkConfig) !== null && _newClientOptions$net !== void 0 && _newClientOptions$net.logEventUrl)) {
                newClientOptions.networkConfig = _objectSpread(_objectSpread({}, newClientOptions.networkConfig), {}, {
                  logEventUrl: DEFAULT_EVENT_LOGGING_API
                });
              }
              if (newClientOptions.perimeter === PerimeterType.FEDRAMP_MODERATE) {
                // disable all logging in FedRAMP to prevent egress of sensitive data
                newClientOptions.disableLogging = true;
              }
              sdkKey = newClientOptions.sdkKey, environment = newClientOptions.environment, _updateUserCompletionCallback = newClientOptions.updateUserCompletionCallback, _perimeter = newClientOptions.perimeter, restClientOptions = _objectWithoutProperties(newClientOptions, _excluded);
              this.sdkKey = sdkKey;
              this.user = toStatsigUser(identifiers, customAttributes, this.sdkKey);
              statsigOptions = _objectSpread(_objectSpread({}, restClientOptions), {}, {
                environment: {
                  tier: environment
                },
                includeCurrentPageUrlWithEvents: false,
                dataAdapter: this.dataAdapter,
                overrideAdapter: this.overrideAdapter
              });
              _context9.prev = 12;
              this.statsigClient = new StatsigClient(sdkKey, this.user, statsigOptions);
              this.dataAdapter.setBootstrapData(initializeValues);
              _context9.next = 17;
              return this.statsigClient.initializeAsync();
            case 17:
              _context9.next = 29;
              break;
            case 19:
              _context9.prev = 19;
              _context9.t0 = _context9["catch"](12);
              if (_context9.t0 instanceof Error) {
                // eslint-disable-next-line no-console
                console.error("Error occurred when trying to initialise the Statsig client, error: ".concat(_context9.t0 === null || _context9.t0 === void 0 ? void 0 : _context9.t0.message));
              }
              // eslint-disable-next-line no-console
              console.warn("Initialising Statsig client with default sdk key and without values");
              this.statsigClient = new StatsigClient(DEFAULT_CLIENT_KEY, this.user, statsigOptions);
              this.dataAdapter.setBootstrapData();
              _context9.next = 27;
              return this.statsigClient.initializeAsync();
            case 27:
              this.initWithDefaults = true;
              throw _context9.t0;
            case 29:
            case "end":
              return _context9.stop();
          }
        }, _callee9, this, [[12, 19]]);
      }));
      function initFromValues(_x25, _x26, _x27) {
        return _initFromValues.apply(this, arguments);
      }
      return initFromValues;
    }()
    /**
     * This method updates the user for this client with the bootstrap values returned from a given
     * Promise.
     * It uses the customAttributes from fetching experiment values to update the Statsig user but
     * uses the customAttributes from given input to check if the user has changed.
     *
     * @param {Identifiers} identifiers
     * @param {CustomAttributes} customAttributes
     * @param {Promise<InitializeValues>} getInitializeValues
     * @private
     */
    )
  }, {
    key: "updateUserUsingInitializeValuesProducer",
    value: (function () {
      var _updateUserUsingInitializeValuesProducer = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee11(getInitializeValues, identifiers, customAttributes) {
        var _this9 = this;
        var originalInitPromise, initializeValuesPromise, updateUserPromise;
        return _regeneratorRuntime.wrap(function _callee11$(_context11) {
          while (1) switch (_context11.prev = _context11.next) {
            case 0:
              this.assertInitialized(this.statsigClient);
              if (this.initPromise) {
                _context11.next = 3;
                break;
              }
              throw new Error('The client must be initialized before you can update the user.');
            case 3:
              if (!this.isCurrentUser(identifiers, customAttributes)) {
                _context11.next = 5;
                break;
              }
              return _context11.abrupt("return", this.initPromise);
            case 5:
              // Wait for the current initialize/update to finish
              originalInitPromise = this.initPromise;
              _context11.prev = 6;
              _context11.next = 9;
              return this.initPromise;
            case 9:
              _context11.next = 13;
              break;
            case 11:
              _context11.prev = 11;
              _context11.t0 = _context11["catch"](6);
            case 13:
              initializeValuesPromise = getInitializeValues();
              updateUserPromise = this.updateStatsigClientUser(initializeValuesPromise, identifiers, customAttributes); // We replace the init promise here since we are essentially re-initializing the client at this
              // point. Any subsequent calls to await client.initialize() or client.updateUser()
              // will now also await this user update.
              this.initPromise = updateUserPromise.catch( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee10() {
                return _regeneratorRuntime.wrap(function _callee10$(_context10) {
                  while (1) switch (_context10.prev = _context10.next) {
                    case 0:
                      // If the update failed then it changed nothing, so revert back to the original promise.
                      _this9.initPromise = originalInitPromise;

                      // Set the user profile again to revert back to the current user
                      if (!_this9.provider) {
                        _context10.next = 4;
                        break;
                      }
                      _context10.next = 4;
                      return _this9.provider.setProfile(_this9.initOptions, _this9.currentIdentifiers, _this9.currentAttributes);
                    case 4:
                    case "end":
                      return _context10.stop();
                  }
                }, _callee10);
              })));
              return _context11.abrupt("return", updateUserPromise);
            case 17:
            case "end":
              return _context11.stop();
          }
        }, _callee11, this, [[6, 11]]);
      }));
      function updateUserUsingInitializeValuesProducer(_x28, _x29, _x30) {
        return _updateUserUsingInitializeValuesProducer.apply(this, arguments);
      }
      return updateUserUsingInitializeValuesProducer;
    }()
    /**
     * This method updates the user on the nested Statsig client
     *
     * @param identifiers
     * @param customAttributes
     * @param initializeValuesPromise
     * @private
     */
    )
  }, {
    key: "updateStatsigClientUser",
    value: (function () {
      var _updateStatsigClientUser = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee12(initializeValuesPromise, identifiers, customAttributes) {
        var _this$initOptions, _this$initOptions$upd;
        var initializeValues, user, _updateUserCompletion, _ref4, errMsg, success, errorMessage;
        return _regeneratorRuntime.wrap(function _callee12$(_context12) {
          while (1) switch (_context12.prev = _context12.next) {
            case 0:
              this.assertInitialized(this.statsigClient);
              _context12.prev = 1;
              _context12.next = 4;
              return initializeValuesPromise;
            case 4:
              initializeValues = _context12.sent;
              user = toStatsigUser(identifiers, initializeValues.customAttributesFromFetch, this.sdkKey);
              _context12.next = 13;
              break;
            case 8:
              _context12.prev = 8;
              _context12.t0 = _context12["catch"](1);
              // Make sure the updateUserCompletionCallback is called for any errors in our custom code.
              // This is not necessary for the updateUserWithValues call, because the Statsig client will
              // already invoke the callback itself.
              errMsg = _context12.t0 instanceof Error ? _context12.t0.message : JSON.stringify(_context12.t0);
              (_updateUserCompletion = (_ref4 = this.initOptions).updateUserCompletionCallback) === null || _updateUserCompletion === void 0 || _updateUserCompletion.call(_ref4, false, errMsg);
              throw _context12.t0;
            case 13:
              success = true;
              errorMessage = null;
              _context12.prev = 15;
              this.dataAdapter.setBootstrapData(initializeValues.experimentValues);
              this.user = user;
              _context12.next = 20;
              return this.statsigClient.updateUserAsync(this.user);
            case 20:
              _context12.next = 26;
              break;
            case 22:
              _context12.prev = 22;
              _context12.t1 = _context12["catch"](15);
              success = false;
              errorMessage = String(_context12.t1);
            case 26:
              (_this$initOptions = this.initOptions) === null || _this$initOptions === void 0 || (_this$initOptions$upd = _this$initOptions.updateUserCompletionCallback) === null || _this$initOptions$upd === void 0 || _this$initOptions$upd.call(_this$initOptions, success, errorMessage);
              if (!success) {
                _context12.next = 33;
                break;
              }
              this.currentIdentifiers = identifiers;
              this.currentAttributes = customAttributes;
              this.subscriptions.anyUpdated();
              _context12.next = 34;
              break;
            case 33:
              throw new Error('Failed to update user. An unexpected error occured.');
            case 34:
            case "end":
              return _context12.stop();
          }
        }, _callee12, this, [[1, 8], [15, 22]]);
      }));
      function updateStatsigClientUser(_x31, _x32, _x33) {
        return _updateStatsigClientUser.apply(this, arguments);
      }
      return updateStatsigClientUser;
    }())
  }, {
    key: "getPackageVersion",
    value:
    /**
     * @returns string version of the current package in semver style.
     */
    function getPackageVersion() {
      return CLIENT_VERSION;
    }

    /**
     * Returns a specified layer otherwise returns an empty layer as a default value if the layer doesn't exist.
     *
     * @param {string} layerName - The name of the layer
     * @param {Object} options
     * @param {boolean} options.fireLayerExposure - Whether or not to fire the exposure event for the
     * layer. Defaults to true. To log an exposure event manually at a later time, use
     * {@link Client.manuallyLogLayerExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
     * @returns A layer
     * @example
     * ```ts
     * const layer = client.getLayer('example-layer-name');
     * const exampletitle: string = layer.get("title", "Welcome to Statsig!");
     * ```
     */
  }, {
    key: "getLayer",
    value: function getLayer( /** The name of the layer */
    layerName) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      try {
        this.assertInitialized(this.statsigClient);
        var _options$fireLayerExp = options.fireLayerExposure,
          fireLayerExposure = _options$fireLayerExp === void 0 ? true : _options$fireLayerExp;
        return Layer.fromLayer(this.statsigClient.getLayer(layerName, {
          disableExposureLog: !fireLayerExposure
        }));
      } catch (error) {
        // Log the first occurrence of the error
        if (!this.hasGetLayerErrorOccurred) {
          // eslint-disable-next-line no-console
          console.warn({
            msg: 'An error has occurred getting the layer. Only the first occurrence of this error is logged.',
            layerName: layerName,
            error: error
          });
          this.hasGetLayerErrorOccurred = true;
        }

        // Return a default value
        return Layer.fromLayer(_makeLayer(layerName, {
          reason: 'Error'
        }, null));
      }
    }

    /**
     * Returns the value of a given parameter in a layer config.
     *
     * @template T
     * @param {string} layerName - The name of the layer
     * @param {string} parameterName - The name of the parameter to fetch from the layer config
     * @param {T} defaultValue - The value to serve if the layer or parameter do not exist, or if the
     * returned value does not match the expected type.
     * @param {Object} options
     * @param {boolean} options.fireLayerExposure - Whether or not to fire the exposure event for the
     * layer. Defaults to true. To log an exposure event manually at a later time, use
     * {@link Client.manuallyLogLayerExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-))
     * @param {function} options.typeGuard - A function that asserts that the return value has the expected type. If this function returns false, then the default value will be returned instead. This can be set to protect your code from unexpected values being set remotely. By default, this will be done by asserting that the default value and value are the same primitive type.
     * @returns The value of the parameter if the layer and parameter both exist, otherwise the default value.
     * @example
     * ``` ts
     * type ValidColor = 'blue' | 'red' | 'yellow';
     * type ValidColorTypeCheck = (value: unknown) => value is ValidColor;
     *
     * const isValidColor: ValidColorTypeCheck =
     *    (value: unknown) => typeof value === 'string' && ['blue', 'red', 'yellow'].includes(value);
     *
     * const buttonColor: ValidColor = client.getLayerValue(
     *    'example-layer-name',
     *    'backgroundColor',
     *    'yellow',
     *    {
     *        typeGuard: isValidColor
     *    }
     * );
     * ```
     */
  }, {
    key: "getLayerValue",
    value: function getLayerValue(layerName, parameterName, defaultValue) {
      var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
      var layer = this.getLayer(layerName, options);
      try {
        var typeGuard = options.typeGuard;
        return layer.get(parameterName, defaultValue, typeGuard);
      } catch (error) {
        // Log the first occurrence of the error
        if (!this.hasGetLayerValueErrorOccurred) {
          // eslint-disable-next-line no-console
          console.warn({
            msg: 'An error has occurred getting the layer value. Only the first occurrence of this error is logged.',
            layerName: layerName,
            defaultValue: defaultValue,
            options: options,
            error: error
          });
          this.hasGetLayerValueErrorOccurred = true;
        }
        return defaultValue;
      }
    }
  }]);
}();