---
title: Updating Codes
---

# Updating Codes

*Note: This is more complicated than it should be: we need to simplify the process. We just haven't gotten there yet with everything else going on!*

### Steps

First read [Running Tools](/development/running-tools)

1. Update [Script Metadata](/development/updating-codes/updating-script-metadata)
2. [Update Population/GDP/Literacy](/development/updating-codes/updating-population-gdp-literacy)
3. [Update Language/Script/Region Subtags](/development/updating-codes/update-languagescriptregion-subtags)
4. [Update Subdivision Codes](/development/updating-codes/updating-subdivision-codes)
5. [Update Subdivision translations](/development/updating-codes/updating-subdivision-translations) (new)
6. [Update Currency Codes](/development/updating-codes/update-currency-codes)
7. [Update Time Zone Data for ZoneParser](/development/updating-codes/update-time-zone-data-for-zoneparser)
8. [Update Validity XML](/development/updating-codes/update-validity-xml)
    1. [Update Language/Script/Country Information](/development/updating-codes/update-language-script-info)
    2. [LikelySubtags and Default Content](/development/updating-codes/likelysubtags-and-default-content)
    3. Update IANA/FIPS Mappings
        1. TBD - Describe what to do. The URLs are
        2. http://www.iana.org/domain-names.htm
        3. http://www.iana.org/root-whois/index.html
        4. http://data.iana.org/TLD/tlds-alpha-by-domain.txt
9. Reformat plurals/ordinals.xml with GeneratedPluralRules.java. Review carefully before checking in.
    1. Regenerate Supplemental Charts: [Generating Charts](/development/cldr-big-red-switch/generating-charts)


For information about **Version Info** and external metadata, see [Updating External Metadata](/development/updating-codes/external-version-metadata)

