---
title: CLDR Releases/Downloads
---

# CLDR Releases/Downloads

*Each release of the Unicode CLDR is a stable release and may be used as reference material or cited as a normative reference by other specifications. Each version, once published, is absolutely stable and will never change. Implementations may also apply [CLDR Corrigenda](/index/corrigenda) to a release. Bug reports and feature requests for subsequent versions may be filed at [Bug Reports](/index/bug-reports).*


## Downloads

The following table lists the files for each released version. For license information, see the Unicode [Terms of Use](https://unicode.org/copyright.html). The top two rows have permalinks for the latest version and the latest development version (snapshot). They are followed by the specific release versions. See Key to Header Links below chart.

| No. | Date | Rel. Note | Data | Charts | Spec | Delta Tickets | GitHub Tag | Delta DTD | CLDR JSON |
|:---:|:----------:|:---------:|:------:|:--------:|:------------:|:---:|:----------:|:---------:|:---------:|
| Latest |  | [latest-version][] | [latest-data][] | [latest-charts][] | [latest-ldml][] | [latest-tickets][] | [release-47][]| [latest-delta-dtd][] | See release notes |
| Dev |  | [dev-version][] |  | [dev-charts][]| [dev-ldml][] | [dev-tickets][] | [main][]| [dev-delta-dtd][] | See release notes |
|  47 | 2025-03-13 | [v47][] | [CLDR47][] | [Charts47][] | [LDML47][] | [Δ47][] | [release-47][] | [ΔDtd47] | [47.0.0][] |
| 46.1 | 2024-12-18 | [v46.1][] | n/a | [Charts46.1][] | [LDML46.1][] | [Δ46.1][] | [release-46-1][] | [ΔDtd46.1][] | [46.1.0][] |
|  46 | 2024-10-24 | [v46][] | [CLDR46][] | [Charts46][] | [LDML46][] | [Δ46][] | [release-46][] | [ΔDtd46][] | [46.0.0][] |
| 45 | 2024-04-17 | [v45][] | [CLDR45][] | [Charts45][] | [LDML45][] | [Δ45][] | [release-45][] | [ΔDtd45][] | [45.0.0][] |
| 44.1 | 2023-12-13 | [v44.1][] | n/a | n/a | [LDML44.1][] | [Δ44.1][] | [release-44-1][] | See [44.1 Changes][] | [44.1.0][] |
| 44 | 2023-10-31 | [v44][] | [CLDR44][] | [Charts44][] | [LDML44][] | [Δ44][] | [release-44][] | [ΔDtd44][] | [44.0.0][] |
| 43.1 | 2023-06-15 | [v43.1][] | n/a | n/a | [LDML43.1][] | [Δ43.1][] | [release-43-1][] | See [43.1 Changes][] | [43.1.0][] |
| 43 | 2023-04-12 | [v43][] | [CLDR43][] | [Charts43][] | [LDML43][] | [Δ43][] | [release-43][] | [ΔDtd43][] | [43.0.0][] |
| 42 | 2022-10-19 | [v42][] | [CLDR42][] | [Charts42][] | [LDML42][] | [Δ42][] | [release-42][] | [ΔDtd42][] | [42.0.0][] |
| 41 | 2022-04-06 | [v41][] | [CLDR41][] | [Charts41][] | [LDML41][] | [Δ41][] | [release-41][] | [ΔDtd41][] | [41.0.0][] |
| 40 | 2021-10-27 | [v40][] | [CLDR40][]| [Charts40][] | [LDML40][] | [Δ40][] | [release-40][] | [ΔDtd40][] | [40.0.0][] |
| 39 | 2021-04-07 | [v39][] | [CLDR39][] | [Charts39][] | [LDML39][] | [Δ39][] | [release-39][] | [ΔDtd39][] | [39.0.0][] |
| 38.1 | 2020-12-17  | [v38.1][] | [CLDR38.1][] | [Charts38.1][] | [LDML38][] | [Δ38.1][] | [release-38-1][] | [ΔDtd38.1][] | [38.1.0][] |
| 38 | 2020-10-28  | [v38][] | [CLDR38][] | [Charts38][] | [LDML38][] | [Δ38][] | [ΔDtd38][] | [38.0.0][] |
| 37 | 2020-04-23 | [v37][]| [CLDR37][] | [Charts37][] | [LDML37][] | [Δ37][] | [release-37][] | [ΔDtd37][] | [37.0.0][] |
| 36.1 | 2020-03-11 | v36.1 | [CLDR36.1][] | [Charts36.1][] | [LDML36][] | [Δ36.1][] | [release-36-1][] | [ΔDtd36.1][] | n/a |
| 36 | 2019-10-04 | [v36][] | [CLDR36][] | [Charts36][] | [LDML36][] | [Δ36][]| [release-36][] | [ΔDtd36][] | [36.0.0][] |
| 35.1 | 2019-04-17 | [v35.1][] | [CLDR35.1][]| [Charts35.1][] | [LDML35][] | [Δ35.1][] | [release-35-1][] | [ΔDtd35][]| [35.1.0][] |
| 35 | 2019-03-27 | [v35][] | [CLDR35][]| [Charts35.1][] | [LDML35][] | [Δ35][] | [release-35][] | [ΔDtd35][]| [35.0.0][] |
| 34 | 2018-10-15 | [v34][] | [CLDR34][] | [Charts34][] | [LDML34][] | [~~Δ34~~][] | [release-34][] | [ΔDtd34][] | [34.0.0][] |
| 33.1 | 2018-06-20 | [v33.1][] | [CLDR33.1][] | [Charts34*][] | [LDML33*][] | [~~Δ33.1~~][] | [release-33-1][] | [ΔDtd33][] [*][] | n/a |
| 33 | 2018-03-26 | [v33][] | [CLDR33][]| [Charts33][] | [LDML33][] | [~~Δ33~~][] | [release-33][] | [ΔDtd33][] | n/a |
| 32.0.1 | 2017-12-08 | [v32][] | [CLDR32.0.1][] | [Charts32][] | [LDML32][] | [~~Δ32.0.1~~][] | [release-32-0-1][] | [ΔDtd32][] | n/a |
| 32 | 2017-11-01 | [v32][] | [CLDR32][] | [Charts32][] | [LDML32][] | [~~Δ32~~][] | [release-32][] | [ΔDtd32][] | [32.0.0][] |
| 31.0.1 | 2017-04-07 | [v31][] | [CLDR31.0.1][] | [Charts31][] | [LDML31][] | [~~Δ31.0.1~~][] | [release-31-0-1][] |   | [31.0.1][] |
| 31 | 2017-03-20 | [v31][] | [CLDR31][] | [Charts31][] | [LDML31][] | [~~Δ31~~][] | [release-31][] |   | [31.0.0][] |
| 30.0.3 | 2016-12-02 | v30 | [CLDR30.0.3][] | [Charts30][] | [LDML30][] | [~~Δ30.0.3~~][] | [release-30-0-3][] |   | n/a |
| 30.0.2 | 2016-10-17 | v30 | [CLDR30.0.2][] | [Charts30][] | [LDML30][] | [~~Δ30.0.2~~][] | [release-30-0-2][] |   | [30.0.2][] |
| 30.0.1 | 2016-10-14 | v30 | [CLDR30.0.1][] | [Charts30][] | [LDML30][] | [~~Δ30.0.1~~][] | [release-30-0-1][] |   | [31.0.1][] |
| 30 | 2016-10-05 | v30 | [CLDR30][] | [Charts30][] | [LDML30][] | [~~Δ30~~][] | [release-30][] |   | [30.0.0][] |
| 29 | 2016-03-16 | v29 | [CLDR29][] | [Charts29][] | [LDML29][] | [~~Δ29~~][] | [release-29][] |   | n/a |
| 28 | 2015-09-17 | v28 | [CLDR28][] | [Charts28][] | [LDML28][] | [~~Δ28~~][] | [release-28][] |   | [28.0.0][] |
| 27-0-1 | 2015-03-30 | v27 | [CLDR27.0.1][] | [Charts27][] | [LDML27][] | [~~Δ27.0.1~~][] | [release-27-0-1][] |   | [27.0.1][] [27.0.3][] |
| 27 | 2015-03-19 | v27 | [CLDR27][] | [Charts27][] | [LDML27][] | [~~Δ27~~][] | [release-27][] |   | [27.0.0][] |
| 26.0.1 | 2014-12-04 | v26.0.1 | [CLDR26.0.1][] | [Charts26][] | [LDML26][] | ~~n/a~~ | [release-26-0-1][] |   | n/a |
| 26 | 2014-09-18 | v26 | [CLDR26][] | [Charts26][] | [LDML26][] | [~~Δ26~~][] | [release-26][] |   | n/a |
| 25 | 2014-03-19 | v25 | [CLDR25][] | [Charts25][]| [LDML25][] | [~~Δ25~~][] | [release-25][] |   | n/a |
| 24 | 2013-09-18 | v24 | [CLDR24][] | [Charts24][] | [LDML24][] | [~~Δ24~~][] | [release-24][] |   | n/a |
| 23.1 | 2013-05-15 | v23.1 | [CLDR23.1][] | [Charts23.1][] | [LDML23][] | [~~Δ23.1~~][] | [release-23-1][] |   | n/a |
| 23 | 2013-03-15 | v23 | [CLDR23][] | [Charts23][] | [LDML23][] | [~~Δ23~~][] | [release-23][] |   | n/a |
| 22.1 | 2012-10-26 | v22.1 | [CLDR22.1][] | [Charts22.1][] | [LDML22.1][] | [~~Δ22.1~~][] | [release-22-1][] |   | n/a |
| 22 | 2012-09-10 | v22 | [CLDR22][] | [Charts22][] | [LDML22][] | [~~Δ22~~][] | [release-22][] |   | n/a |
| 21.0.2 | 2012-06-06 | v21.0.2 | via SVN |   | [LDML21.0.1][] | [~~Δ21.0.2~~][] | [release-21-0-2][] |   | n/a |
| 21.0.1 | 2012-03-21 | v21.0.1 | via SVN |   | [LDML21.0.1][] | [~~Δ21.0.1~~][] | [release-21-0-1][] |   | n/a |
| 21.0 | 2012-02-10 | v21 | [CLDR21][]|   | [LDML21][] | [~~Δ21~~][] | [release-21][] |   | n/a |
| 2.0.1 | 2011-07-18 | v2.0.1 | [CLDR2.0.1][] |   | [LDML2.0.1][] | [~~Δ2.0.1~~][] | [release-2-0-1][] |   | n/a|
| 2.0 | 2011-05-25 | v2.0 | [CLDR2.0][] |   | [LDML2.0][] | [~~Δ2.0~~][] | [release-2-0][] |   | n/a |
| 1.9.1 | 2011-03-11 | [v1.9.1][] | [CLDR1.9.1][] |   | [LDML1.9][] | [~~Δ1.9.1~~][] | release-1-9-1 |   | n/a |
| 1.9 | 2010-12-01 | v1.9 | [CLDR1.9.0][] |   | [LDML1.9][] | [~~Δ1.9~~][] | release-1-9 |   | n/a |
| 1.8.1 | 2010-04-29 | v1.8.1 | [CLDR1.8.1][] |   | [LDML1.8.1][] | [~~Δ1.8.1~~][] | release-1-8-1 |   | n/a |
| 1.8.0 | 2010-03-17 | v1.8.0 | [CLDR1.8.0][] |   | [LDML1.8.0][] | [~~Δ1.8.0~~][] | release-1-8 |   | n/a |
| 1.7.2 | 2009-12-10 | v1.7.2 | [CLDR1.7.2][] |   | [LDML1.7.2][] | [~~Δ1.7.2~~][] | release-1-7-2 |   | n/a |
| 1.7.1.2 | 2009-11-11 | v1.7.1 | [via SVN][] |   | [LDML1.7][] | [~~Δ1.7.1.2~~][] | release-1-7-1-2 |   | n/a |
| 1.7.1.1 | 2009-10-29 | v1.7.1 | [via SVN][] |   | [LDML1.7][] | [~~Δ1.7.1.1~~][] | release-1-7-1-1 |   | n/a |
| 1.7.1 | 2009-06-29 | v1.7.1 | [CLDR1.7.1][] |   | [LDML1.7][] | [~~Δ1.7.1~~][] | release-1-7-1 |   | n/a |
| 1.7 | 2009-05-08 | v1.7 | [CLDR1.7][] |   | [LDML1.7][] | [~~Δ1.7~~][] | release-1-7 |   | n/a |
| 1.6.1 | 2008-07-23 | v1.6.1 | [CLDR1.6.1][] |   | [LDML1.6.1][] | [~~Δ1.6.1~~][] | release-1-6-1 |   | n/a |
| 1.6 | 2008-07-02 | v1.6 | [CLDR1.6][] |   | [LDML1.6][] | [~~Δ1.6~~][] | release-1-6 |   | n/a |
| 1.5.1 | 2007-12-21 | v1.5.1 | [CLDR1.5.1][] |   | [LDML1.5.1][] | [~~Δ1.5.1~~][] | release-1-5-1 |   | n/a |
| 1.5 | 2007-07-31 | v1.5 | [CLDR1.5][] |   | [LDML1.5][] | [~~Δ1.5~~][] | release-1-5 |   | n/a |
| 1.4.1 | 2006-11-03 | v1.4.1 | [CLDR1.4.1][]|   | [LDML1.4.1][] | [~~Δ1.4.1~~][] | release-1-4-1 |   | n/a |
| 1.4 | 2006-07-17 | v1.4 | [CLDR1.4][] |   | [LDML1.4][] | [~~Δ1.4~~][] | release-1-4 |   | n/a |
| 1.3 | 2005-06-02 | v1.3 | [CLDR1.3][] |   | [LDML1.3][] | [~~Δ1.3~~][] | release-1-3 |   | n/a |
| 1.2 | 2004-11-04 | v1.2 | [CLDR1.2][] |   | [LDML1.2][] | [~~Δ1.2~~][] | release-1-2 |   | n/a |
| 1.1.1 | 2004-07-29 | n/a | [CLDR1.1.1][] |   | [LDML1.1][] | n/a | release-1-1-1 |   | n/a |
| 1.1 | 2004-06-08 | n/a | [CLDR1.1][] |   | [LDML1.1][] | n/a | release-1-1 |  | n/a |
| 1.0 | 2003-12-19 |   |    |see [CLDR 1.0 Release][]|  |  |release-1-0| | n/a |

### Key to Header

| Item | Description|
|:----:|:-----------|
| No. | CLDR Version Number. |
| Date | CLDR Version Release Date. |
| Rel. Note | A general description of the contents of the release, relevant notes about the release including migration warnings. |
| Data | A set of zip files containing the contents of the release (the files are complete in themselves, and do not require files from earlier releases -- for the structure of the zip file, see [Repository Organization](/index/downloads#Repository_Organization)). |
| Charts | A set of charts showing some of the data in the release. |
| Spec | The version of [UTS #35: LDML](https://www.unicode.org/reports/tr35/) that corresponds to the release. |
| Delta Tickets | A list of all the tickets (fixes and features) in the release, which can be used to get the precise corresponding file changes. (Some earlier releases are not available in this way due to the JIRA migration, but all of the information is available in GitHub or JIRA.) |
| Github Tag | The files in the release, accessible via [Repository Access](/index/downloads#latest_draft_version). |
| Delta DTDs | A link pointing to charts of changes in the DTDs since the previous version. |

Access to the latest working snapshot of CLDR, and access to data collected for other platforms is available through the web. The **Github Tag** can be used to get the contents of the release, as described below.


## JSON Data

The JSON data is packaged and released in the CLDR-JSON repository. See https://github.com/unicode-cldr/cldr-json for more information.


## Repository Access

CLDR files are maintained in a git source code repository at https://github.com/unicode-org/cldr.git.

**Note**: On Sep 14, 2021, the main branch was renamed to 'main'.

There are several ways to access the repository contents.


### Simple Browsing

For browsing a particular file for a particular version, or revision history of a particular file, use the [GitHub Browser](https://github.com/unicode-org/cldr.git). For example:

- Go to the latest French LDML file at https://github.com/unicode-org/cldr/blob/main/common/main/fr.xml.
- See all the files in a directory structure using https://github.com/unicode-org/cldr.
- Find a file using https://github.com/unicode-org/cldr/find/main (click in the space after "cldr /" above the blue box).


### Advanced Git Access

For more access to the source repository, you can use an git client to check out or export LDML files directory from the repository at https://github.com/unicode-org/cldr.git

-   You will need "git-lfs" installed to be able to compile the CLDR tools. See https://git-lfs.github.com or use the [Github Desktop](https://desktop.github.com) client.


## Repository Organization

At the top level of each GitHub repository tree, there are a number of special folders, plus a number of platform folders.

- *common* — CLDR data corresponding to the release
    - *annotations* — annotations and TTS names for characters
        - *annotationsDerived* — names algorithmically derived based on structure
    - *bcp47* — data for unicode locale extensions
    - *casing* — intended capitalization for various categories in each language, for use by the Survey Tool
    - *collation* — collation LDML files
    - *dtd* — the latest XML DTD files for the release
    - *main* — the main locale-dependent LDML files
    - *properties* — property files in UCD format
    - *rbnf* — rule-based number formats
    - *segments* — rules for segmenting text
    - *subdivisions* — names of region (country) subdivisions.
    - *supplemental* — additional files with non-linguistic data.
    - *testData* — folders of test data for implementations.
    - *transforms* — data for transliteration and other text transforms
    - *uca* — customized Unicode collation data
    - *validity* — data for validating BCP47 identifiers
- *docs* — the source of the LDML spec and other documents
- *exemplars/main* — preliminary exemplar character data for locales which do not yet have data in CLDR.
- *keyboards* — source files for the CLDR keyboard data
    - *seed* — preliminary locales that do not yet have sufficient vetted data.
    - *annotations*
    - *casing*
    - *collation*
    - *main*
    - *rbnf*
        - *transforms* — these folders have the same structure as their counterparts in common. Note that supplemental is not duplicated.
- *~~specs~~* — deprecated, with contents moved to docs.
- [*tools*](https://github.com/unicode-org/cldr/tree/main/tools) — source for internal tools for processing CLDR data
    - *SurveyConsole* — (not currently deployed) This is a tool providing an operational dashboard for the Survey Tool
    - c/*genldml* — The only C language tool, this was used to convert ICU format data into LDML.
    - *cldr-apps-webdriver* — Automated tests for the Survey Tool to ensure that it remains operational.
    - [*cldr-apps*](https://github.com/unicode-org/cldr/tree/main/tools/cldr-apps) — Survey Tool source code
    - [*cldr-code*](https://github.com/unicode-org/cldr/tree/main/tools/cldr-code) — main source code for the CLDR tooling
    - *python* — utility Python code
    - *scripts* — accessory shell scripts, used for CLDR process and Survey Tool deployment


The common, dtd, and tools folders are in each release.


## POSIX Data

**Note**: Beginning with CLDR 21, the CLDR project no longer publishes POSIX-format locale sources as part of its distribution. The POSIX locale generation tools will continue to be made available as a part of the release. Developers who require POSIX compliant locales can generate them using these tools.

CLDR had historically included reference versions of POSIX-format locale source files that are generated using the default options for each supported locale. The reference versions of POSIX source information contain those data fields that are included in the POSIX specification.

Many operating system platforms provide additional extensions to the minimal POSIX required field set. Individual implementations may require addition of the platform-specific fields or a non-default character repertoire in order to provide full functionality on a given POSIX compliant operating system. As of the current release, the POSIX locale generation tools do not generate such platform-specific extensions, but they can be modified to support this.


## CLDR 1.0 Release

The 1.0 version of CLDR is described here for historical interest only. It was hosted on the OpenI18N site before the CLDR project moved to the Unicode Consortium.


|||
|---|---|
| 1.0 Version: | https://www.openi18n.org/spec/ldml/1.0/ldml-spec.htm |
| 1.0 Namespace: | https://www.openi18n.org/spec/ldml |
| 1.0 DTDs: | https://www.openi18n.org/spec/ldml/1.0/ldml.dtd |
|  | https://www.openi18n.org/spec/ldml/1.0/ldmlSupplemental.dtd |

<!-- Latest release -->
[latest-version]: /index/downloads/latest
[latest-data]: https://unicode.org/Public/cldr/latest/
[latest-charts]: https://www.unicode.org/cldr/charts/latest/index.html
[latest-ldml]: https://www.unicode.org/reports/tr35/
[latest-tickets]: https://unicode-org.atlassian.net/issues/?filter=10838
[latest-delta-dtd]: https://www.unicode.org/cldr/charts/latest/supplemental/dtd_deltas.html

<!-- Dev release -->
[dev-version]: /index/downloads/dev
[dev-charts]: https://unicode.org/cldr/charts/dev
[dev-ldml]: https://www.unicode.org/reports/tr35/proposed.html
[dev-tickets]: https://unicode-org.atlassian.net/issues/?filter=10837
[main]: https://github.com/unicode-org/cldr.git
[dev-delta-dtd]: https://www.unicode.org/cldr/charts/dev/supplemental/dtd_deltas.html

<!-- 47 release: 2025-03-13 -->
[CLDR47]: https://unicode.org/Public/cldr/47/
[Charts47]: https://unicode.org/cldr/charts/47
[LDML47]: https://www.unicode.org/reports/tr35/47
[Δ47]: https://unicode-org.atlassian.net/issues/?filter=10836
[release-47]: https://github.com/unicode-org/cldr/releases/tag/release-47
[ΔDtd47]: https://www.unicode.org/cldr/charts/47/supplemental/dtd_deltas.html
[47.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/47.0.0
[v47]: /downloads/cldr-47

<!-- 46.1 release: 2024-12-18 -->
[v46.1]: /index/downloads/cldr-46#461-changes
[Charts46.1]: https://unicode.org/cldr/charts/46.1/
[LDML46.1]: https://www.unicode.org/reports/tr35/tr35-74/tr35.html
[Δ46.1]: https://unicode-org.atlassian.net/issues/?filter=10835
[release-46-1]: https://github.com/unicode-org/cldr/releases/tag/release-46-1
[ΔDtd46.1]: https://www.unicode.org/cldr/charts/46.1/supplemental/dtd_deltas.html
[46.1.0]: https://github.com/unicode-org/cldr-json/releases/tag/46.1.0

<!-- 46 release: 2024-10-24 -->
[v46]: /index/downloads/cldr-46
[CLDR46]: https://unicode.org/Public/cldr/46/
[Charts46]: https://unicode.org/cldr/charts/46/
[LDML46]: https://www.unicode.org/reports/tr35/tr35-73/tr35.html
[Δ46]: https://unicode-org.atlassian.net/issues/?filter=10834
[release-46]: https://github.com/unicode-org/cldr/releases/tag/release-46
[ΔDtd46]: https://www.unicode.org/cldr/charts/46/supplemental/dtd_deltas.html
[46.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/46.0.0

<!-- 45 release: 2024-04-17 -->
[v45]: /index/downloads/cldr-45
[CLDR45]: https://unicode.org/Public/cldr/45/
[Charts45]: https://unicode.org/cldr/charts/45/
[LDML45]: https://www.unicode.org/reports/tr35/tr35-72/tr35.html
[Δ45]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2245%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-45]: https://github.com/unicode-org/cldr/tree/release-45
[ΔDtd45]: https://unicode.org/cldr/charts/45/supplemental/dtd_deltas.html
[45.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/45.0.0

<!-- 44.1 release: 2023-12-13 -->
[v44.1]: /index/downloads/cldr-44#h.nvqx283jwsx
[LDML44.1]: https://www.unicode.org/reports/tr35/tr35-71/tr35.html
[Δ44.1]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2244%2E1%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-44-1]: https://github.com/unicode-org/cldr/tree/release-44-1
[44.1 Changes]: /index/downloads/cldr-44#h.nvqx283jwsx
[44.1.0]: https://github.com/unicode-org/cldr-json/releases/tag/44.1.0

<!-- 44 release: 2023-10-31 -->
[v44]: /index/downloads/cldr-44
[CLDR44]: https://unicode.org/Public/cldr/44/
[Charts44]: https://unicode.org/cldr/charts/44/
[LDML44]: https://www.unicode.org/reports/tr35/tr35-70/tr35.html
[Δ44]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2244%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-44]: https://github.com/unicode-org/cldr/tree/release-44
[ΔDtd44]: https://unicode.org/cldr/charts/44/supplemental/dtd_deltas.html
[44.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/44.0.0

<!-- 43.1 release: 2023-06-15 -->
[v43.1]: /index/downloads/cldr-43#h.qobmda543waj
[LDML43.1]: https://www.unicode.org/reports/tr35/tr35-69/tr35.html
[Δ43.1]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2243%2E1%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-43-1]: https://github.com/unicode-org/cldr/tree/release-43-1
[43.1 Changes]: /index/downloads/cldr-43#h.qobmda543waj
[43.1.0]: https://github.com/unicode-org/cldr-json/releases/tag/43.1.0

<!-- 43 release: 2023-04-12 -->
[v43]: /index/downloads/cldr-43
[CLDR43]: https://unicode.org/Public/cldr/43/
[Charts43]: https://www.unicode.org/cldr/charts/43/
[LDML43]: https://www.unicode.org/reports/tr35/tr35-68/tr35.html
[Δ43]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20in%20(Fixed%2C%20%22Fix%20in%20Survey%20Tool%20(CLDR)%22%2C%20%22Fixed%20non-repo%22)%20AND%20fixVersion%20%3D%20%2243%22%20ORDER%20BY%20resolution%20ASC%2C%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-43]: https://github.com/unicode-org/cldr/tree/release-43
[ΔDtd43]: https://www.unicode.org/cldr/charts/43/supplemental/dtd_deltas.html
[43.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/43.0.0

<!-- 42 release: 2022-10-19 -->
[v42]: /index/downloads/cldr-42
[CLDR42]: https://unicode.org/Public/cldr/42/
[Charts42]: https://www.unicode.org/cldr/charts/42/
[LDML42]: https://www.unicode.org/reports/tr35/tr35-67/tr35.html
[Δ42]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20in%20(Fixed%2C%20%22Fix%20in%20Survey%20Tool%20(CLDR)%22%2C%20%22Fixed%20non-repo%22)%20AND%20fixVersion%20%3D%20%2242%22%20ORDER%20BY%20resolution%20ASC%2C%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-42]: https://github.com/unicode-org/cldr/tree/release-42
[ΔDtd42]: https://www.unicode.org/cldr/charts/42/supplemental/dtd_deltas.html
[42.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/42.0.0

<!-- 41 release: 2022-04-06 -->
[v41]: /index/downloads/cldr-41
[CLDR41]: https://unicode.org/Public/cldr/41/
[Charts41]: https://www.unicode.org/cldr/charts/41/
[LDML41]: https://www.unicode.org/reports/tr35/tr35-66/tr35.html
[Δ41]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2241%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-41]: https://github.com/unicode-org/cldr/tree/release-41
[ΔDtd41]: https://www.unicode.org/cldr/charts/41/supplemental/dtd_deltas.html
[41.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/41.0.0

<!-- 40 release: 2022-04-06 -->
[v40]: /index/downloads/cldr-40
[CLDR40]: https://unicode.org/Public/cldr/40/
[Charts40]: https://www.unicode.org/cldr/charts/40/ 
[LDML40]: https://www.unicode.org/reports/tr35/tr35-65/tr35.html
[Δ40]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2240%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-40]: https://github.com/unicode-org/cldr/tree/release-40
[ΔDtd40]: https://www.unicode.org/cldr/charts/40/supplemental/dtd_deltas.html
[40.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/40.0.0

<!-- 39 release: 2021-04-07 -->
[v39]: /index/downloads/cldr-39
[CLDR39]: https://unicode.org/Public/cldr/39/
[Charts39]: https://www.unicode.org/cldr/charts/39/
[LDML39]: https://www.unicode.org/reports/tr35/tr35-63/tr35.html
[Δ39]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2239%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-39]: https://github.com/unicode-org/cldr/tree/release-39
[ΔDtd39]: https://www.unicode.org/cldr/charts/39/supplemental/dtd_deltas.html
[39.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/39.0.0

<!-- 38.1 release: 2020-12-17 -->
[v38.1]: /index/downloads/cldr-38?pli=1#TOC-CLDR-38.1
[CLDR38.1]: https://unicode.org/Public/cldr/38.1
[Charts38.1]: https://www.unicode.org/cldr/charts/38.1/index.html
[LDML38]: https://www.unicode.org/reports/tr35/tr35-61/tr35.html
[Δ38.1]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2238%2E1%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-38-1]: https://github.com/unicode-org/cldr/tree/release-38-1
[ΔDtd38.1]: https://www.unicode.org/cldr/charts/38.1/supplemental/dtd_deltas.html
[38.1.0]: https://github.com/unicode-org/cldr-json/releases/tag/38.1.0

<!-- 38 release: 2020-10-28 -->
[v38]: /index/downloads/cldr-38
[CLDR38]: https://unicode.org/Public/cldr/38/
[Charts38]: https://www.unicode.org/cldr/charts/38/
[LDML38]: https://www.unicode.org/reports/tr35/tr35-61/tr35.html
[Δ38]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2238%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-38]: https://github.com/unicode-org/cldr/tree/release-38
[ΔDtd38]: https://www.unicode.org/cldr/charts/38/supplemental/dtd_deltas.html
[38.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/38.0.0

<!-- 37 release: 2020-04-23 -->
[v37]: /index/downloads/cldr-37
[CLDR37]: https://unicode.org/Public/cldr/37/
[Charts37]: https://www.unicode.org/cldr/charts/37/
[LDML37]: https://www.unicode.org/reports/tr35/tr35-59/tr35.html
[Δ37]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2237%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-37]: https://github.com/unicode-org/cldr/tree/release-37
[ΔDtd37]: https://www.unicode.org/cldr/charts/37/supplemental/dtd_deltas.html
[37.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/37.0.0

<!-- 36.1 release: 2020-03-11 -->
[CLDR36.1]: https://unicode.org/Public/cldr/36.1/
[Charts36.1]: https://www.unicode.org/cldr/charts/36.1/
[LDML36]: https://www.unicode.org/reports/tr35/tr35-57/tr35.html
[Δ36.1]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20fixVersion%20%3D%20%2236.1%22%20ORDER%20BY%20component%20ASC%2C%20priority%20DESC%2C%20created%20ASC
[release-36-1]: https://github.com/unicode-org/cldr/tree/release-36-1
[ΔDtd36.1]: https://www.unicode.org/cldr/charts/36.1/supplemental/dtd_deltas.html

<!-- 36 release: 2019-10-04 -->
[v36]: /index/downloads/cldr-36
[CLDR36]: https://unicode.org/Public/cldr/36/
[Charts36]: https://www.unicode.org/cldr/charts/36/
[LDML36]: https://www.unicode.org/reports/tr35/tr35-57/tr35.html
[Δ36]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20resolution%20%3D%20Fixed%20AND%20fixVersion%20%3D%20%2236%22%20ORDER%20BY%20created%20ASC
[release-36]: https://github.com/unicode-org/cldr/tree/release-36
[ΔDtd36]: https://www.unicode.org/cldr/charts/36/supplemental/dtd_deltas.html
[36.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/36.0.0

<!-- 35.1 release: 2019-04-17 -->
[v35.1]: /index/downloads/cldr-35?pli=1#TOC-V35.1
[CLDR35.1]: https://unicode.org/Public/cldr/35.1/
[Charts35.1]: https://www.unicode.org/cldr/charts/35/
[LDML35]: https://www.unicode.org/reports/tr35/tr35-55/tr35.html
[Δ35.1]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20fixVersion%20%3D%2035.1%20ORDER%20BY%20created%20ASC
[release-35-1]: https://github.com/unicode-org/cldr/tree/release-35-1
[ΔDtd35]: https://www.unicode.org/cldr/charts/35/supplemental/dtd_deltas.html
[35.1.0]: https://github.com/unicode-org/cldr-json/releases/tag/35.1.0

<!-- 35 release: 2019-03-27 -->
[v35]: /index/downloads/cldr-35
[CLDR35]: https://unicode.org/Public/cldr/35/
[Charts35.1]: https://www.unicode.org/cldr/charts/35/
[LDML35]: https://www.unicode.org/reports/tr35/tr35-55/tr35.html
[Δ35]: https://unicode-org.atlassian.net/issues/?jql=project%20%3D%20CLDR%20AND%20status%20%3D%20Done%20AND%20fixVersion%20%3D%20%2235%22%20ORDER%20BY%20created%20ASC
[release-35]: https://github.com/unicode-org/cldr/tree/release-35
[ΔDtd35]: https://www.unicode.org/cldr/charts/35/supplemental/dtd_deltas.html
[35.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/35.0.0

<!-- 34 release: 2018-10-15 -->
[v34]: /index/downloads/cldr-34
[CLDR34]: https://unicode.org/Public/cldr/34/
[Charts34]: https://www.unicode.org/cldr/charts/34/
[LDML34]: https://www.unicode.org/reports/tr35/tr35-53/tr35.html
[~~Δ34~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=34&group=component&max=999
[release-34]: https://github.com/unicode-org/cldr/releases/tag/release-34
[ΔDtd34]: https://www.unicode.org/cldr/charts/34/supplemental/dtd_deltas.html
[34.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/34.0.0

<!-- 33.1 release: 2018-06-20 -->
[v33.1]: /index/downloads/cldr-33-1
[CLDR33.1]: https://unicode.org/Public/cldr/33.1/
[Charts34*]: https://www.unicode.org/cldr/charts/34/
[LDML33*]: https://www.unicode.org/reports/tr35/tr35-51/tr35.html
[~~Δ33.1~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=33.1&group=component&max=999
[release-33-1]: https://github.com/unicode-org/cldr/releases/tag/release-33-1/
[ΔDtd33]: https://www.unicode.org/cldr/charts/33/supplemental/dtd_deltas.html
[*]: https://unicode.org/cldr/trac/changeset?reponame=&new=HEAD@tags/release-33/common/dtd&old=HEAD@tags/release-33-1/common/dtd

<!-- 33.1 release: 2018-06-20 -->
[v33]: /index/downloads/cldr-33
[CLDR33]: https://unicode.org/Public/cldr/33/
[Charts33]: https://www.unicode.org/cldr/charts/33/
[LDML33]: https://www.unicode.org/reports/tr35/tr35-51/tr35.html
[~~Δ33~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=33&group=component&max=999
[release-33]: https://github.com/unicode-org/cldr/releases/tag/release-33/
[ΔDtd33]: https://www.unicode.org/cldr/charts/33/supplemental/dtd_deltas.html

<!-- 32.0.1 release: 2017-12-08 -->
[v32]: /index/downloads/cldr-32
[CLDR32.0.1]: https://unicode.org/Public/cldr/32.0.1/
[Charts32]: https://www.unicode.org/cldr/charts/32/
[LDML32]: https://www.unicode.org/reports/tr35/tr35-49/tr35.html
[~~Δ32.0.1~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=32.0.1&group=component&max=999
[release-32-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-32-0-1/
[ΔDtd32]: https://www.unicode.org/cldr/charts/32/supplemental/dtd_deltas.html

<!-- 32 release: 2017-11-01 -->
[v32]: /index/downloads/cldr-32
[CLDR32]: https://unicode.org/Public/cldr/32/
[Charts32]: https://www.unicode.org/cldr/charts/32/
[LDML32]: https://www.unicode.org/reports/tr35/tr35-49/tr35.html
[~~Δ32~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=32&group=component&max=999
[release-32]: https://github.com/unicode-org/cldr/releases/tag/release-32/
[ΔDtd32]: https://www.unicode.org/cldr/charts/32/supplemental/dtd_deltas.html
[32.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/32.0.0

<!-- 31.0.1 release: 2017-04-07 -->
[v31]: /index/downloads/cldr-31
[CLDR31.0.1]: https://www.unicode.org/Public/cldr/31.0.1/
[Charts31]: https://www.unicode.org/cldr/charts/31/
[LDML31]: https://www.unicode.org/reports/tr35/tr35-47/tr35.html
[~~Δ31.0.1~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=31&milestone=31.0.1&group=component&max=999&col=id&col=summary&col=owner&col=type&col=status&col=priority&col=time&order=priority
[release-31-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-31-0-1/
[31.0.1]: https://github.com/unicode-org/cldr-json/releases/tag/31.0.1

<!-- 31 release: 2017-03-20-->
[v31]: /index/downloads/cldr-31
[CLDR31]: https://unicode.org/Public/cldr/31/
[Charts31]: https://www.unicode.org/cldr/charts/31/
[LDML31]: https://www.unicode.org/reports/tr35/tr35-47/tr35.html
[~~Δ31~~]: https://unicode.org/cldr/trac/query?resolution=fixed&milestone=31&group=component&max=999
[release-31]: https://github.com/unicode-org/cldr/releases/tag/release-31/
[31.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/31.0.0

<!-- 30.0.3 release: 2016-12-02 -->
[CLDR30.0.3]: https://unicode.org/Public/cldr/30.0.3/
[Charts30]: https://www.unicode.org/cldr/charts/30/
[LDML30]: https://www.unicode.org/reports/tr35/tr35-45/tr35.html
[~~Δ30.0.3~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&revw=!&milestone=30.0.3&group=component&max=999&col=id&col=summary&order=priority
[release-30-0-3]: https://github.com/unicode-org/cldr/releases/tag/release-30-0-3

<!-- 30.0.2 release: 2016-10-17 -->
[CLDR30.0.2]: https://unicode.org/Public/cldr/30.0.2/
[Charts30]: https://www.unicode.org/cldr/charts/30/
[LDML30]: https://www.unicode.org/reports/tr35/tr35-45/tr35.html
[~~Δ30.0.2~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&revw=!&milestone=30.0.2&group=component&max=999&col=id&col=summary&order=priority
[release-30-0-2]: https://github.com/unicode-org/cldr/releases/tag/release-30-0-2
[30.0.2]: https://github.com/unicode-org/cldr-json/releases/tag/30.0.2

<!-- 30.0.1 release: 2016-10-14 -->
[CLDR30.0.1]: https://unicode.org/Public/cldr/30.0.1/
[Charts30]: https://www.unicode.org/cldr/charts/30/
[LDML30]: https://www.unicode.org/reports/tr35/tr35-45/tr35.html
[~~Δ30.0.1~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&revw=!&milestone=30.0.1&group=component&max=999&col=id&col=summary&order=priority
[release-30-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-30-0-1
[31.0.1]: https://github.com/unicode-org/cldr-json/releases/tag/31.0.1

<!-- 30 release: 2016-10-05 -->
[CLDR30]: https://unicode.org/Public/cldr/30/
[Charts30]: https://www.unicode.org/cldr/charts/30/
[LDML30]: https://www.unicode.org/reports/tr35/tr35-45/tr35.html
[~~Δ30~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&resolution=fixed&milestone=30&group=component&max=999&col=id&col=summary
[release-30]: https://github.com/unicode-org/cldr/releases/tag/release-30
[30.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/30.0.0

<!-- 29 release: 2016-03-16 -->
[CLDR29]: https://unicode.org/Public/cldr/29/
[Charts29]: https://www.unicode.org/cldr/charts/29/
[LDML29]: https://www.unicode.org/reports/tr35/tr35-43/tr35.html
[~~Δ29~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&resolution=fixed&milestone=29&group=component&max=999&col=id&col=summary
[release-29]: https://github.com/unicode-org/cldr/releases/tag/release-29

<!-- 28 release: 2015-09-17 -->
[CLDR28]: https://unicode.org/Public/cldr/28/
[Charts28]: https://www.unicode.org/cldr/charts/28/
[LDML28]: https://www.unicode.org/reports/tr35/tr35-41/tr35.html
[~~Δ28~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&resolution=fixed&milestone=28&group=component&max=999&col=id&col=summary
[release-28]: https://github.com/unicode-org/cldr/releases/tag/release-28
[28.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/28.0.0

<!-- 27-0-1 release: 2015-03-30 -->
[CLDR27.0.1]: https://unicode.org/Public/cldr/27.0.1/
[Charts27]: https://www.unicode.org/cldr/charts/27/
[LDML27]: https://www.unicode.org/reports/tr35/tr35-39/tr35.html
[~~Δ27.0.1~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&resolution=fixed&milestone=27.0.1&group=component&max=999&col=id&col=summary
[release-27-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-27-0-1
[27.0.1]: https://github.com/unicode-org/cldr-json/releases/tag/27.0.1
[27.0.3]: https://github.com/unicode-org/cldr-json/releases/tag/27.0.3
[CLDR27]: https://unicode.org/Public/cldr/27/
[Charts27]: https://www.unicode.org/cldr/charts/27/
[LDML27]: https://www.unicode.org/reports/tr35/tr35-39/tr35.html
[~~Δ27~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&resolution=fixed&milestone=27&group=component&max=999&col=id&col=summary
[release-27]: https://github.com/unicode-org/cldr/releases/tag/release-27
[27.0.0]: https://github.com/unicode-org/cldr-json/releases/tag/27.0.0

<!-- 26.0.1 release: 2014-12-04 -->
[CLDR26.0.1]: https://unicode.org/Public/cldr/26.0.1/
[Charts26]: https://www.unicode.org/cldr/charts/26/index.html
[LDML26]: https://www.unicode.org/reports/tr35/tr35-37/tr35.html
[release-26-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-26-0-1

<!-- 26 release: 2014-09-18 -->
[CLDR26]: https://unicode.org/Public/cldr/26/
[Charts26]: https://www.unicode.org/cldr/charts/26/index.html
[LDML26]: https://www.unicode.org/reports/tr35/tr35-37/tr35.html
[~~Δ26~~]: https://unicode.org/cldr/trac/query?status=closed&status=reviewing&resolution=fixed&milestone=26&group=component&max=999&col=id&col=summary
[release-26]: https://github.com/unicode-org/cldr/releases/tag/release-26

<!-- 25 release: 2014-03-19 -->
[CLDR25]: https://unicode.org/Public/cldr/25/
[Charts25]: https://www.unicode.org/cldr/charts/25/index.html
[LDML25]: https://www.unicode.org/reports/tr35/tr35-35/tr35.html
[~~Δ25~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=25dsub&milestone=25design&milestone=25M1&milestone=25rc&milestone=25final&max=900
[release-25]: https://github.com/unicode-org/cldr/releases/tag/release-25

<!-- 24 release: 2013-09-18 -->
[CLDR24]: https://unicode.org/Public/cldr/24/
[Charts24]: https://www.unicode.org/cldr/charts/24/index.html
[LDML24]: https://www.unicode.org/reports/tr35/tr35-33/tr35.html
[~~Δ24~~]: https://unicode.org/cldr/trac/query?status=closed&resolution=fixed&resolution=duplicate&resolution=as-designed&resolution=moot&resolution=fix-in-surveytool&milestone=24dsub&milestone=24dsub2&milestone=24dvet&milestone=24rc&milestone=24final&max=900
[release-24]: https://github.com/unicode-org/cldr/releases/tag/release-24

<!-- 23.1 release: 2013-05-15 -->
[CLDR23.1]: https://unicode.org/Public/cldr/23.1/
[Charts23.1]: https://www.unicode.org/cldr/charts/23.1/index.html
[LDML23]: https://www.unicode.org/reports/tr35/tr35-31/tr35.html
[~~Δ23.1~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=23.1
[release-23-1]: https://github.com/unicode-org/cldr/releases/tag/release-23-1

<!-- 23 release: 2013-03-15 -->
[CLDR23]: https://unicode.org/Public/cldr/23/
[Charts23]: https://www.unicode.org/cldr/charts/23/index.html
[LDML23]: https://www.unicode.org/reports/tr35/tr35-31/tr35.html
[~~Δ23~~]: https://unicode.org/cldr/trac/query?max=900&milestone=23dsub&milestone=23dres&milestone=23&order=id&col=id&col=summary&col=milestone&col=type&col=status&col=priority&col=component&revw=!
[release-23]: https://github.com/unicode-org/cldr/releases/tag/release-23

<!-- 22.1 release: 2012-10-26 -->
[CLDR22.1]: https://unicode.org/Public/cldr/22.1/
[Charts22.1]: https://www.unicode.org/cldr/charts/22.1/index.html
[LDML22.1]: https://www.unicode.org/reports/tr35/tr35-29.html
[~~Δ22.1~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=22.1
[release-22-1]: https://github.com/unicode-org/cldr/releases/tag/release-22-1#docs

<!-- 22 release: 2012-09-10 -->
[CLDR22]: https://unicode.org/Public/cldr/22/
[Charts22]: https://www.unicode.org/cldr/charts/22/index.html
[LDML22]: https://www.unicode.org/reports/tr35/tr35-27.html
[~~Δ22~~]: https://unicode.org/cldr/trac/query?max=900&milestone=22dvet&milestone=22dres&milestone=22&milestone=22dsub&order=priority
[release-22]: https://github.com/unicode-org/cldr/releases/tag/release-22

<!-- 21.0.2 release: 2012-06-06 -->
[LDML21.0.1]: https://www.unicode.org/reports/tr35/tr35-25.html
[~~Δ21.0.2~~]: https://unicode.org/cldr/trac/query?milestone=21.0.2
[release-21-0-2]: https://github.com/unicode-org/cldr/releases/tag/release-21-0-2

<!-- 21.0.1 release: 2012-03-21 -->
[LDML21.0.1]: https://www.unicode.org/reports/tr35/tr35-25.html
[~~Δ21.0.1~~]: https://unicode.org/cldr/trac/query?milestone=21.0.1&revw=%21
[release-21-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-21-0-1

<!-- 21.0 release: 2012-02-10 -->
[CLDR21]: https://unicode.org/Public/cldr/21/
[LDML21]: https://www.unicode.org/reports/tr35/tr35-23.html
[~~Δ21~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=21m1&milestone=21m2&milestone=21
[release-21]: https://github.com/unicode-org/cldr/releases/tag/release-21

<!-- 2.0.1 release: 2011-07-18 -->
[CLDR2.0.1]: https://unicode.org/Public/cldr/2.0.1/
[LDML2.0.1]: https://www.unicode.org/reports/tr35/tr35-21.html
[~~Δ2.0.1~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=2.0.1
[release-2-0-1]: https://github.com/unicode-org/cldr/releases/tag/release-2-0-1

<!-- 2.0 release: 2011-05-25 -->
[CLDR2.0]: https://unicode.org/Public/cldr/2.0.0/
[LDML2.0]: https://www.unicode.org/reports/tr35/tr35-19.html
[~~Δ2.0~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=2.0&milestone=2.0m1&milestone=2.0m2
[release-2-0]: https://github.com/unicode-org/cldr/releases/tag/release-2-0

<!-- 1.9.1 release: 2011-03-11 -->
[v1.9.1]: /index/downloads/cldr-1-9-1
[CLDR1.9.1]: https://unicode.org/Public/cldr/1.9.1/
[LDML1.9]: https://www.unicode.org/reports/tr35/tr35-17.html
[~~Δ1.9.1~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=1.9.1

<!-- 1.9 release: 2010-12-01 -->
[CLDR1.9.0]: https://unicode.org/Public/cldr/1.9.0/
[LDML1.9]: https://www.unicode.org/reports/tr35/tr35-17.html
[~~Δ1.9~~]: https://unicode.org/cldr/trac/query?status=closed&order=priority&milestone=1.9m1&milestone=1.9m2&milestone=1.9RC

<!-- 1.8.1 release: 2010-04-29 -->
[CLDR1.8.1]: https://unicode.org/Public/cldr/1.8.1/
[LDML1.8.1]: https://www.unicode.org/reports/tr35/tr35-16.html
[~~Δ1.8.1~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=1.8.1p1&milestone=1.8.1p2&milestone=1.8.1&milestone=1.8.1o

<!-- 1.8.0 release: 2010-03-17 -->
[CLDR1.8.0]: https://unicode.org/Public/cldr/1.8.0/
[LDML1.8.0]: https://www.unicode.org/reports/tr35/tr35-15.html
[~~Δ1.8.0~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=1.8p1&milestone=1.8p2&milestone=1.8&milestone=1.8o

<!-- 1.7.2 release: 2009-12-10 -->
[CLDR1.7.2]: https://unicode.org/Public/cldr/1.7.2/
[LDML1.7.2]: https://www.unicode.org/reports/tr35/tr35-13.html
[~~Δ1.7.2~~]: https://unicode.org/cldr/trac/query?status=closed&milestone=1.7.2

<!-- 1.7.1.2 release: 2009-11-11 -->
[via SVN]: https://github.com/unicode-org/cldr/releases/tag/release-1-7-1-2/
[LDML1.7]: https://www.unicode.org/reports/tr35/tr35-12.html
[~~Δ1.7.1.2~~]: https://unicode.org/cldr/trac/query?status=closed&order=id&col=id&col=summary&milestone=1.7.1&milestone=1.7.1.1&milestone=1.7.1.2

<!-- 1.7.1.1 release: 2009-10-29 -->
[via SVN]: https://github.com/unicode-org/cldr/releases/tag/release-1-7-1-1/
[LDML1.7]: https://www.unicode.org/reports/tr35/tr35-12.html
[~~Δ1.7.1.1~~]: https://unicode.org/cldr/trac/query?status=closed&order=id&col=id&col=summary&milestone=1.7.1&milestone=1.7.1.1

<!-- 1.7.1 release: 2009-06-29 -->
[CLDR1.7.1]: https://unicode.org/Public/cldr/1.7.1/
[LDML1.7]: https://www.unicode.org/reports/tr35/tr35-12.html
[~~Δ1.7.1~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.7.1

<!-- 1.7 release: 2009-05-08 -->
[CLDR1.7]: https://unicode.org/Public/cldr/1.7.0/
[LDML1.7]: https://www.unicode.org/reports/tr35/tr35-12.html
[~~Δ1.7~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.7

<!-- 1.6.1 release: 2008-07-23 -->
[CLDR1.6.1]: https://unicode.org/Public/cldr/1.6.1/
[LDML1.6.1]: https://www.unicode.org/reports/tr35/tr35-11.html
[~~Δ1.6.1~~]: (https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.6.1

<!-- 1.6 release: 2008-07-02 -->
[CLDR1.6]: https://unicode.org/Public/cldr/1.6.0/
[LDML1.6]: https://www.unicode.org/reports/tr35/tr35-10.html
[~~Δ1.6~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.6

<!-- 1.5.1 release: 2007-12-21 -->
[CLDR1.5.1]: https://unicode.org/Public/cldr/1.5.1/
[LDML1.5.1]: https://www.unicode.org/reports/tr35/tr35-9.html
[~~Δ1.5.1~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.5.1

<!-- 1.5 release: 2007-07-31 -->
[CLDR1.5]: https://unicode.org/Public/cldr/1.5.0/
[LDML1.5]: https://www.unicode.org/reports/tr35/tr35-8.html
[~~Δ1.5~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.5

<!-- 1.4.1 release: 2006-11-03 -->
[CLDR1.4.1]: https://unicode.org/Public/cldr/1.4.1/
[LDML1.4.1]: https://www.unicode.org/reports/tr35/tr35-7.html
[~~Δ1.4.1~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.4.1

<!-- 1.4 release: 2006-07-17 -->
[CLDR1.4]: https://unicode.org/Public/cldr/1.4.0/
[LDML1.4]: https://www.unicode.org/reports/tr35/tr35-6.html
[~~Δ1.4~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.4

<!-- 1.3 release: 2005-06-02 -->
[CLDR1.3]: https://unicode.org/Public/cldr/1.3.0/
[LDML1.3]: https://www.unicode.org/reports/tr35/tr35-5.html
[~~Δ1.3~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.3

<!-- 1.2 release: 2004-11-04 -->
[CLDR1.2]: https://unicode.org/Public/cldr/1.2.0/
[LDML1.2]: https://www.unicode.org/reports/tr35/tr35-4.html
[~~Δ1.2~~]: https://unicode.org/cldr/trac/query?status=closed&col=id&col=summary&milestone=1.2

<!-- 1.1.1 release: 2004-07-29 -->
[CLDR1.1.1]: https://unicode.org/Public/cldr/1.1.1/
[LDML1.1]: https://www.unicode.org/reports/tr35/tr35-2.html

<!-- 1.1 release: 2004-06-08 -->
[CLDR1.1]: https://unicode.org/Public/cldr/1.1.0/
[LDML1.1]: https://www.unicode.org/reports/tr35/tr35-2.html

<!-- 1.0 release: 2004-06-08 -->
[CLDR 1.0 Release]: https://unicode.org/cldr/repository_access.html#CLDR_1.0_Release
