---
title: Transforms
---

# Transforms

Transforms describe ways of converting text. Most often these are transliterations, converting one script to another, such as:

| Source | Transliteration |
|---|---|
| キャンパス | kyanpasu |
| Αλφαβητικός Κατάλογος | Alphabētikós Katálogos |
| биологический | biologicheskij |

For those, the name of the language or script is used.

There are a few others that have special purposes, listed below. Note that whatever translation is used, it should be short (a few words at most).

For the specialized acronyms (marked with \*):

- If your language uses Latin letters, you probably want to leave this alone unless there is a well-known name in your language.
- For non-Latin, you should transcribe this into your alphabet, and if the name is not commonly understood, add the English in parentheses, such as "XXX (BGN)" or "XXX (UNGEGN)".

| Code | Description |
|---|---|
| BGN* | Transliterations according to the [US BGN](https://www.usgs.gov/us-board-on-geographic-names).  |
| UNGEGN* | Transliterations according to the [UN Group of Experts on Geographical Names](https://unstats.un.org/unsd/ungegn/). |
| Numeric | Numeric conversions. |
| Tone | Linguistic [tone](https://en.wikipedia.org/wiki/Tone_(linguistics)) such as used in Chinese. |
| Accents | Accents, such as in ö or é. |
| Publishing | Forms of characters more appropriate for publishing. Examples:<br />  ‘ or ’ or  …<br /> rather than generic ASCII characters like:<br /> ' or ... (three periods). |
| Jamo | The name for the [units of the Korean alphabet](https://en.wikipedia.org/wiki/Jamo#Jamo). |
| Pinyin | The name for the [standard romanization](https://en.wikipedia.org/wiki/Pinyin) (transliteration into Latin letters) for the Chinese language. |
| Fullwidth | Full-width or "wide" characters, such as  Ａ and  ォ |
| Halfwidth | Half-width or "narrow" characters, such as A and  ｫ   |

