# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.operations import Operations
from .operations.redis_operations import RedisOperations
from .operations.firewall_rules_operations import FirewallRulesOperations
from .operations.redis_firewall_rule_operations import RedisFirewallRuleOperations
from .operations.patch_schedules_operations import PatchSchedulesOperations
from . import models


class RedisManagementClientConfiguration(AzureConfiguration):
    """Configuration for RedisManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription credentials which uniquely
     identify the Microsoft Azure subscription. The subscription ID forms part
     of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not isinstance(subscription_id, str):
            raise TypeError("Parameter 'subscription_id' must be str.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(RedisManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('redismanagementclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class RedisManagementClient(object):
    """REST API for Azure Redis Cache Service.

    :ivar config: Configuration for client.
    :vartype config: RedisManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: .operations.Operations
    :ivar redis: Redis operations
    :vartype redis: .operations.RedisOperations
    :ivar firewall_rules: FirewallRules operations
    :vartype firewall_rules: .operations.FirewallRulesOperations
    :ivar redis_firewall_rule: RedisFirewallRule operations
    :vartype redis_firewall_rule: .operations.RedisFirewallRuleOperations
    :ivar patch_schedules: PatchSchedules operations
    :vartype patch_schedules: .operations.PatchSchedulesOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription credentials which uniquely
     identify the Microsoft Azure subscription. The subscription ID forms part
     of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = RedisManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2016-04-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.redis = RedisOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.firewall_rules = FirewallRulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.redis_firewall_rule = RedisFirewallRuleOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.patch_schedules = PatchSchedulesOperations(
            self._client, self.config, self._serialize, self._deserialize)
