# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NetworkInterface(Model):
    """Network details of the environment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar private_ip_address: PrivateIp address of the Compute VM
    :vartype private_ip_address: str
    :ivar ssh_authority: Connection information for Linux
    :vartype ssh_authority: str
    :ivar rdp_authority: Connection information for Windows
    :vartype rdp_authority: str
    :ivar username: Username of the VM
    :vartype username: str
    """

    _validation = {
        'private_ip_address': {'readonly': True},
        'ssh_authority': {'readonly': True},
        'rdp_authority': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(NetworkInterface, self).__init__(**kwargs)
        self.private_ip_address = None
        self.ssh_authority = None
        self.rdp_authority = None
        self.username = None
