# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AutoUpdateSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update settings of OneAgent."""

    ENABLED = "ENABLED"
    DISABLED = "DISABLED"


class AvailabilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The availability state of OneAgent."""

    CRASHED = "CRASHED"
    LOST = "LOST"
    MONITORED = "MONITORED"
    PRE_MONITORED = "PRE_MONITORED"
    SHUTDOWN = "SHUTDOWN"
    UNEXPECTED_SHUTDOWN = "UNEXPECTED_SHUTDOWN"
    UNKNOWN = "UNKNOWN"
    UNMONITORED = "UNMONITORED"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class LiftrResourceCategories(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Liftr resource category."""

    UNKNOWN = "Unknown"
    MONITOR_LOGS = "MonitorLogs"


class LogModule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tells whether log modules are enabled or not."""

    ENABLED = "ENABLED"
    DISABLED = "DISABLED"


class ManagedIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of managed identity assigned to this resource."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_AND_USER_ASSIGNED = "SystemAndUserAssigned"


class MarketplaceSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag specifying the Marketplace Subscription Status of the resource. If payment is not made in
    time, the resource will go in Suspended state.
    """

    ACTIVE = "Active"
    SUSPENDED = "Suspended"


class MonitoringStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag specifying if the resource monitoring is enabled or disabled."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class MonitoringType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The monitoring mode of OneAgent."""

    CLOUD_INFRASTRUCTURE = "CLOUD_INFRASTRUCTURE"
    FULL_STACK = "FULL_STACK"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the monitoring resource."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"


class SendAadLogsStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether AAD logs are being sent."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SendActivityLogsStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether activity logs are being sent."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SendingLogsStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether logs are being sent."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SendingMetricsStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether metrics are being sent."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SendSubscriptionLogsStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether subscription logs are being sent."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class SingleSignOnStates(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Various states of the SSO resource."""

    INITIAL = "Initial"
    ENABLE = "Enable"
    DISABLE = "Disable"
    EXISTING = "Existing"


class SSOStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether SSO is enabled or not."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class TagAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Valid actions for a filtering tag. Exclusion takes priority over inclusion."""

    INCLUDE = "Include"
    EXCLUDE = "Exclude"


class UpdateStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current update status of OneAgent."""

    INCOMPATIBLE = "INCOMPATIBLE"
    OUTDATED = "OUTDATED"
    SCHEDULED = "SCHEDULED"
    SUPPRESSED = "SUPPRESSED"
    UNKNOWN = "UNKNOWN"
    UP2_DATE = "UP2DATE"
    UPDATE_IN_PROGRESS = "UPDATE_IN_PROGRESS"
    UPDATE_PENDING = "UPDATE_PENDING"
    UPDATE_PROBLEM = "UPDATE_PROBLEM"
